#include "mbed.h"
#include "SSD1306.h"
#include "bme280.h"
#include "stdlib.h"
#include "mbed_logo.h"

#define D_SDA                  P0_0
#define D_SCL                  P0_1

//Functions
void triggerfall_1();//Button1 falling interrupt function
void triggerrise_1();//Button1 rising interrupt function
void triggerfall_2();//Button1 falling interrupt function
void triggerrise_2();//Button1 rising interrupt function

float t;
float pr;
int h;

uint8_t address = 0x78;

I2C i2c(D_SDA, D_SCL);

SSD1306 oled(i2c, address);
BME280 bme280;

//Initiate IO
DigitalOut led0(LED1);
DigitalOut led1(LED2);
DigitalOut led2(P0_20);
DigitalOut led3(P0_21);
DigitalOut led4(P0_22, 0);
DigitalIn  sw1(BUTTON1);
DigitalIn  sw2(BUTTON2);

//Initiate input interrupts
InterruptIn sw1Press(BUTTON1);
InterruptIn sw2Press(BUTTON2);

//bme280
void i2cWrite(uint8_t i2c_address, uint8_t *p_data, uint8_t data_size, uint8_t repeated_start)
{
// mbed uses 8-bit addresses, always confusing.
    i2c.write(i2c_address<<1,(const char *)p_data,data_size,repeated_start);
}

void i2cRead(uint8_t i2c_address, uint8_t *p_data, uint8_t data_size)
{
// mbed uses 8-bit addresses, always confusing.
    i2c.read(i2c_address<<1,(char *)p_data,data_size);
}

//ssd1306
void Start_page()
{
    int i=0;
    oled.writeString(1, 3, "Fight Robot");
    while(i<100) {
        oled.writeProgressBar(20,40,i);
        i++;
        wait_ms(10);
    }
    i = 0;
    oled.writeBitmap((uint8_t*) mbed_logo);
    while(i<100){
        i++;
        wait_ms(10);
    }
}
void Display_Meteo(float t, float pr, int h)
{
//    sprintf(buf, "%f", t);
    oled.writeString(1, 2, "T: ");
    oled.printf("%.2f",t);
    oled.printf("%s"," C");
    oled.writeString(3, 2, "P: ");
    oled.printf("%.1f",pr);
    oled.printf("%s"," mmHg");
    oled.writeString(5, 2, "H: ");
    oled.printf("%d",h);
    oled.printf("%s"," %");
}

int main()
{
    //Initialise LED output
    led0=0;
    led1=0;
    led2=0;
    led3=0;
 
    //Set falling and rising edge to apppropriate interrup function
    sw1Press.fall(&triggerfall_1);
    sw1Press.rise(&triggerrise_1);
    sw2Press.fall(&triggerfall_2);
    sw2Press.rise(&triggerrise_2);

    bme280.begin(BME280_I2C_ADDRESS1);
    // Configure for test purposes.
    bme280.writeConfigRegister(BME280_STANDBY_500_US,BME280_FILTER_OFF,0);
    bme280.writeControlRegisters(BME280_OVERSAMPLING_1X,BME280_OVERSAMPLING_1X,BME280_OVERSAMPLING_1X,BME280_MODE_NORMAL);
    Start_page();
    oled.clearDisplay();

    while(1) {
        led4=!led4;
        bme280.read();
        t = bme280.temperature();
        float p = bme280.pressure()/100;
        pr = p*0.750062;
        h = bme280.humidity();
        Display_Meteo(t, pr, h);
        wait_ms(1000);
    }
}
//Button1 falling interrupt function
void triggerfall_1()
{
//Toggle LED1
    led0=!led0;
}
 
//Button1 rising interrupt function
void triggerrise_1()
{
//Toggle LED2
    led1=!led1;
}
//Button1 falling interrupt function
void triggerfall_2()
{
//Toggle LED1
    led2=!led2;
}
 
//Button1 rising interrupt function
void triggerrise_2()
{
//Toggle LED2
    led3=!led3;
}
