/*************************************************************
PROGRAM NAME:  SY202 mbed Lab 07 Part C

DESCRIPTION:  The following program operates two RC servo
              motors moving in windshield wiper-like fashion
              while simultaneously powering a DC motor in
              forward and reverse.
              
CREATED BY:  MIDN 3/C Jordan DiPaola

Library provided by mbed.org

SOURCES:  SY202 Lecture presentations and mbed cookbook for
          general code structure
*************************************************************/

/**********required includes and initial declarations**********/

//required includes with motor declarations
#include "mbed.h"
#include "Motor.h"

//Motor declaration
Motor dcmotor(p23, p24, p25);

//required includes with servo declarations
#include "Servo.h"

//serial declaration
Serial pc(USBTX, USBRX);
Servo myServo1(p21);
Servo myServo2(p22);

/**********main function**********/

int main()
{   //calibrate both servos for PW of
    //0.0018 and a full range of
    //motion approximately 180 degrees
    myServo1.calibrate(0.0009, 90);
    myServo2.calibrate(0.0009, 90);

    //declare initial servo positions
    myServo1 = 0.0;
    myServo2 = 1.0;

    //initialize servo position values and motor speed
    float pos1 = 1.0;
    float pos2 = 0.0;
    float i = 0.2;
    
    while(1) {
        //for the servos in forward
        //and the motor running forward
        while(pos1 >= 0 && pos2 <= 1) {

            pos1 -= 0.0025;
            pos2 += 0.0025;

            myServo1 = pos1;
            myServo2 = pos2;

            dcmotor.speed(i);
            //time increments to result
            //in 5 sec total for this sequence
            wait(0.0125);

        }
        //for the servos in reverse
        //and the motor running reverse
        while(pos1 <= 1 && pos2 >= 0) {
            pos1 += 0.0025;
            pos2 -= 0.0025;

            myServo1 = pos1;
            myServo2 = pos2;

            dcmotor.speed(i * (-1.0));
            //time increments to result
            //in 5 sec total for this sequence
            wait(0.0125);
        }
        //increment the motor speed
        //before next while-loop-sequence
        if(i <= 1) {
            i = i + 0.1;
        }
    }
}