#include "mbed.h"

AnalogIn analog_value(A0);

DigitalOut led[3] = { D10, D11, D12};

void moveRight(float delayR);
void moveLeft(float delayL);

int main()
{
    float meas_r;
    float meas_v;
    float delayR =0.1;
    float delayL =0.2;
    
    printf("\nAnalogIn example\n");

    while(1) {

        meas_r = analog_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
        meas_v = meas_r * 3300; // Converts value in the 0V-3.3V range
        
        // Display values
        printf("measure = %f = %.0f mV\n", meas_r, meas_v);

        // LED is ON is the value is below 1V
        if (meas_v < 1500) {
           
           moveRight(delayR);
                   } 
        
         else {
                    
              moveLeft(delayL);     
                          }
                    
        wait(0.1); // 1 second
    }
}

void moveRight(float delayR){
    
           for (int i =0; i<=2; i++){
                       led[i].write(0);}
            
           
           for (int i =0; i<=2; i++){
            led[i].write(1);
            wait(delayR); 
            led[i].write(0);
            wait(delayR); 
                        } 
             }
   
    void moveLeft(float delayL){
    
           for (int i =2; i>=0; i--){
                       led[i].write(0);}
            
           
           for (int i =2; i>=0; i--){
            led[i].write(1);
            wait(delayL); 
            led[i].write(0);
            wait(delayL); 
                        } 
                        }