#include "mbed.h"

AnalogIn analog_value(A0);

DigitalOut ledR(D10);
DigitalOut ledG(D11);
DigitalOut ledY(D12);

int main()
{
    float meas_r;
    float meas_v;
    
    printf("\nAnalogIn example\n");

    while(1) {

        meas_r = analog_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
        meas_v = meas_r * 3300; // Converts value in the 0V-3.3V range
        
        // Display values
        printf("measure = %f = %.0f mV\n", meas_r, meas_v);

        // LED is ON is the value is below 1V
        if (meas_v < 1500) {
           
            ledR = 1; // LED ON
            ledG = 0; // LED ON
            ledY = 0; // LED ON
            wait(0.1); // 1 second
            
           ledR = 0; // LED ON
            ledG = 1; // LED ON
            ledY = 0; // LED ON
            wait(0.1); // 1 second
        
        
            ledR = 0; // LED ON
            ledG = 0; // LED ON
            ledY = 1; // LED ON
            wait(0.1); // 1 second
        } 
        
         else {
                    
             ledR = 0; // LED ON
            ledG = 0; // LED ON
            ledY = 1; // LED ON
            wait(0.8); // 1 second
            
           ledR = 0; // LED ON
            ledG = 1; // LED ON
            ledY = 0; // LED ON
            wait(0.8); // 1 second
        
        
            ledR = 1; // LED ON
            ledG = 0; // LED ON
            ledY = 0; // LED ON
            wait(0.8); // 1 second        
                    
                    
                    }
                    

        wait(0.1); // 1 second
    }
}
