/**
 * Copyright 2014 Nordic Semiconductor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

#include "mbed.h"

#define LOG_LEVEL_DEBUG
#include "Log.h"
#include "Puck.h"

Puck* puck = &Puck::getPuck();

PwmOut led(LED1);

const UUID IR_SERVICE_UUID = stringToUUID("hello           ");
const UUID COMMAND_UUID    = stringToUUID("hello command   ");

void onCommandWrite(uint8_t* value) {
    LOG_INFO("Command got: %02x\n", *value);
    led = (float)(*value) / 255;
}


int main() {
    puck->addCharacteristic(IR_SERVICE_UUID, COMMAND_UUID, 1);
    puck->init(0xABBA);

    puck->onCharacteristicWrite(&COMMAND_UUID, onCommandWrite);

    while (puck->drive());
}