//In this program the user LED flashes as an SOS Morse code.
//The SOS Morse code is "...---...". Here, a dot is represented
//with the LED being ON for 0.25 second (Dash time. The delay
//between the dots and dashes is set to 0.2 second (GAP time).
//The process is repeated continously after 2 seconds of delay.

//Author: Maria Sokolowska
//Date: July 2020
//File: SOS

#include "mbed.h"
#include "C12832.h"

PwmOut spkr(p26);
DigitalOut LED(LED1);
C12832 lcd(p5, p7, p6, p8, p11);

#define Dot 0.25                        // Dot time
#define Dash 1.0                        // Dash time
#define Gap 0.2                         // Gap time
#define ON 1                            // ON=1
#define OFF 0                           // OFF=0

int main()
{
    int i;
    while(1) {                          //  Do Forever
        for(i = 0; i < 3; i++) {        //Send 3 dots
            LED = ON;                   //LED ON
            wait(Dot);                  //Wait Dot time
            LED = OFF;                  //LED OFF
            wait(Gap);                  // Wait Gap time
        }
        wait(0.5);                      //0.5 second delay

        for(i = 0; i < 3; i++) {        //Send 3 dashes
            LED = ON;                   //LED ON
            wait(Dash);                 //Wait Dash time
            LED = OFF;                  //LED OFF
            wait(Gap);                  // Wait Gap time
        }
            for(i = 0; i < 3; i++) {    //Send 3 dots
            LED = ON;                   //LED ON
            wait(Dot);                  //Wait Dot time
            LED = OFF;                  //LED OFF
            wait(Gap);                  // Wait Gap time
        }
        wait(0.5);                     //0.5 second delay
            {
        {for (float i=0; i<26; i=i+2) { // ambulance sound
        spkr.period(1.0/969.0);
        wait(.5);
        spkr.period(1.0/800.0);
        wait(.5);}
        }
        spkr=0.5;
        
        wait(2.00);        //Wait 2 second before repeating
        {
        lcd.printf("SOS Please Help SOS Please Help"); // LCD display
        }
     }
    }
}

