#include "mbed.h"
#include "SDFileSystem.h"
#include "QEI.h"

SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board p5 - mosi, p6-miso, p7 - sck, p8 - cs 
Serial pc (USBTX,USBRX);
QEI wheel (p29, p30, NC, 2000, QEI::X4_ENCODING); //for encoder


void sd_card_read_test(void);
void file_write_int(int input);

int i= 2;

int main()
{
    sd_card_read_test();
    while(1){
        //pc.printf("Pulses is: %i\r\n", wheel.getPulses());
        file_write_int(wheel.getPulses());
    }
    
}

void sd_card_read_test(void)
{
    pc.printf("SD card test");
    mkdir("/sd/mydir", 0777);
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL)
    {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Test QUI\r\n");
    fclose(fp);
    pc.printf("[ok]\r\n");   
}

void file_write_int(int input)
{
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");
    if(fp == NULL)
    {
        error("Could not open file for write\n");
    }
    fprintf(fp,"%d\r\n",input);
    fclose(fp);
}

