#include "mbed.h"
#include "SDFileSystem.h"
#include "QEI.h"
#include "Timer.h"

DigitalOut myled(LED1);

SDFileSystem sd(p5, p6, p7, p8, "sd");                  // the pinout on the mbed Cool Components workshop board
QEI wheel(p29, p30, NC, 2000, QEI::X4_ENCODING);     // Encoder input pins p29 - A, p30 - B

void SD_card_test();

Timer t;
int pulse = 0;

int main()
{
    SD_card_test();

    FILE *fp = fopen("/sd/mydir/sdtest.txt", "a+");
    
    if(fp == NULL)
    {
        error("Could not open file for write\n");
    }
    t.reset();
    t.start();
    for (int x; x<1000; x++)
    {
        myled = !myled;
        //fprintf(fp,"%d,%d,%d\r\n",x,t.read_us(),wheel.getPulses());
        pulse = wheel.getPulses();
        fprintf(fp, "%d\t %d\t %d\t \r\n",x,t.read_us(),pulse);
        pulse = 0;
    }
    t.stop();
    fclose(fp);
}

void SD_card_test()
{
    mkdir("/sd/mydir", 0777);
    
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL)
    {
        error("Could not open file for write\n");
    }
    fprintf(fp, "malith test final day\r\n");
    fclose(fp); 
}