#include "mbed.h"
#include "USBSerial.h"

SPI spi(p5, p6, p7);      // DAC mosi, miso, sclk
DigitalOut cs(p8);        // active low DAC enable
DigitalOut outen(p21);    // active high pulse output enable
DigitalOut outxpol1(p23); // pulse output x1 polarity
DigitalOut outxpol2(p22); // pulse output x2 polarity
DigitalOut outypol1(p25); // pulse output y1 polarity
DigitalOut outypol2(p24); // pulse output y2 polarity
USBSerial serial;         // USB serial communication

int v = 0;                // voltage 0 to 1023 = 0 to 102.3 V
int t, i, e, len;
char CmdIn[128];
char CmdP0[] = "P=0";     // polarity 0
char CmdP1[] = "P=1";     // polarity 1
char CmdP2[] = "P=2";     // polarity 2
char CmdP3[] = "P=3";     // polarity 3
char CmdO0[] = "O=0";     // output off
char CmdO1[] = "O=1";     // output on
char CmdVn[] = "V=";      // voltage
char CmdID[] = "ID";      // Identification

void Voltage(int d) {
    d = (d<<4)&0x3fff;    // value is bit 13 to 4
    cs = 0;
    spi.write(d);
    cs = 1;
}

int main() {
    outen = 0;            // output off
    outxpol1 = 0;
    outxpol2 = 0;
    outypol1 = 0;
    outypol2 = 0;
    cs = 1;               // spi not selected
    spi.format(16,2);
    spi.frequency(1000000);
    Voltage(v);
    while(1)
    {
        e = 1;            // set error
        serial.scanf("%s", CmdIn);
        if (strcmp(CmdIn, CmdP0) == 0) {
            outxpol1 = 1;
            outxpol2 = 0;
            outypol1 = 1;
            outypol2 = 0;
            e = 0;
        }
        if (strcmp(CmdIn, CmdP1) == 0) {
            outxpol1 = 1;
            outxpol2 = 0;
            outypol1 = 0;
            outypol2 = 1;
            e = 0;
        }
        if (strcmp(CmdIn, CmdP2) == 0) {
            outxpol1 = 0;
            outxpol2 = 1;
            outypol1 = 0;
            outypol2 = 1;
            e = 0;
        }
        if (strcmp(CmdIn, CmdP3) == 0) {
            outxpol1 = 0;
            outxpol2 = 1;
            outypol1 = 1;
            outypol2 = 0;
            e = 0;
        }
        if (strcmp(CmdIn, CmdO0) == 0) {
            outen = 0;
            e = 0;
        }
        if (strcmp(CmdIn, CmdO1) == 0) {
            outen = 1;
            e = 0;
        }
        if (strncmp(CmdIn, CmdVn, 2) == 0) {
            v = 0;
            len = strlen(CmdIn);
            for(i=2; i<len; i++){
                t = CmdIn[i] - '0';
                if ((t >= 0) && (t <= 9)) { 
                    v = v * 10 + t; 
                }
                else {
                    v = -1;   // on input error make v out of range
                    break;
                }
            }
            if ((v >= 0) && (v <= 1023)) {
                Voltage(v);
                e = 0;  
            }
        }
        if (strcmp(CmdIn, CmdID) == 0) {
            serial.printf( "Bias Voltage Generator V1.0\n");
            e = 0;
        }
        if (e == 1) {
            serial.printf( "Command Error ");
            serial.printf("%s\n", CmdIn);
        }
        else {
            serial.printf( "Command Executed\n");  
        }
        wait(1);
    }
}
