#include "mbed.h"
#include "USBSerial.h"

AnalogIn   ain(p20);      // read load voltage
AnalogOut  aout(p18);     // set load current
USBSerial serial;         // USB serial communication

float io = 0;             // load current 0 to 1023
int vi;                   // load voltage
int t, i, e, len;
char CmdIn[128];
char CmdIL[] = "IL=";     // set load current
char CmdVL[] = "VL";      // return load voltage
char CmdID[] = "ID";      // Identification

void SetCurrent(float d) {
    d = d - (d / 10) - 10; // Bodge it !!
    d = d / 1024;         //
    aout = d;
}

int main() {
    SetCurrent(io);
    while(1)
    {
        e = 1;            // set error
        serial.scanf("%s", CmdIn);
        if (strcmp(CmdIn, CmdVL) == 0) {
            vi = ain * 1024;
            serial.printf("%d\n", vi);           
            e = 0;
        }
        if (strncmp(CmdIn, CmdIL, 3) == 0) {
            io = 0;
            len = strlen(CmdIn);
            for(i=3; i<len; i++){
                t = CmdIn[i] - '0';
                if ((t >= 0) && (t <= 9)) { 
                    io = io * 10 + t; 
                }
                else {
                    io = -1;   // on input error make v out of range
                    break;
                }
            }
            if ((io >= 0) && (io <= 1023)) {
                SetCurrent(io);
                e = 0;  
            }
        }
        if (strcmp(CmdIn, CmdID) == 0) {
            serial.printf( "Load Monitor V1.0\n");
            e = 0;
        }
        if (e == 1) {
            serial.printf( "Command Error ");
            serial.printf("%s\n", CmdIn);
        }
        else {
            serial.printf( "Command Executed\n");  
        }
        wait(1);
    }
}
