/***************************************************************************//**
*   @file   AD1234.h
*   @brief  Header file of AD1234 Driver. This driver suppors the following
*              devices: AD1234R, AD1235R, AD1236R
*
*   @author FirstName LastName (email ID)
********************************************************************************
* Copyright 2013(c) Analog Devices, Inc.
*
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification,
* are permitted provided that the following conditions are met:
*  - Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*  - Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in
*    the documentation and/or other materials provided with the
*    distribution.
*  - Neither the name of Analog Devices, Inc. nor the names of its
*    contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*  - The use of this software may or may not infringe the patent rights
*    of one or more patent holders.  This license does not release you
*    from the requirement that you obtain separate licenses from these
*    patent holders to use this software.
*  - Use of the software either in source or binary form, must be run
*    on or directly connected to an Analog Devices Inc. component.
*
* THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* * LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*******************************************************************************/
#include <stdint.h>
#include "platform_drivers.h"

/***Read Write Defines***/
#define ADxxxx_RW               1   /* Read and Write */
#define ADxxxx_R                2   /* Read only */
#define ADxxxx_W                3   /* Write only */

/***Register Defines***/
#define ADXXXX_POW_ON_REG       0x00
#define ADXXXX_POW_REG          0x01
#define ADXXXX_CALIBRATE_REG    0x02


#define ADXXXX_REG_NUM          3   /*Number of registers*/

#define ADXXXX_POW_FULL         0x04
#define ADXXXX_POW_MED          0x03
#define ADXXXX_POW_LOW          0x02
#define ADXXXX_POW_IDLE         0x01

#define ADXXXX_CALIBRATED       1
#define ADXXXX_NOT_CALIBRATED   0

/***Struct Definitions***/

/*Struct to store values of the following
  four fields of each register*/
struct adxxxx_reg {
    int32_t address;
    int32_t value;
    int32_t size;
    int32_t rw;
};

extern struct adxxxx_reg adxxxx_all_regs[ADXXXX_REG_NUM];

/*Struct to hold ADxxxx Specific Values*/
struct adxxxx_descriptor {
    spi_desc *spi_desc; /*SPI Descriptor*/
    i2c_desc *i2c_desc; /*I2C Descriptor*/
    struct adxxxx_reg *all_regs; /*Array of Register Structs*/
    /*Any other fields you want can go
      below, some examples are provided*/
    uint8_t is_calibrated; /*EXAMPLES*/
    uint8_t power_level;
};

/*Struct to hold adxxxx communication info*/
struct adxxxx_init_params {
    spi_init_param spi_init;
    i2c_init_param i2c_params;
    /*Once again, you could put initial 
      values here, which the setup 
      function changes
    */
};

/***Function Prototypes***/

/*Function to setup the file descriptor and start serial communication*/
int adxxxx_setup(struct adxxxx_descriptor **device, struct adxxxx_init_params init_param);

/*Function to write all initial register values*/
int adxxxx_init_regs(struct adxxxx_descriptor *device);

/*Function to read from a register*/
int adxxx_read(struct adxxxx_descriptor *device, struct adxxxx_reg* reg);

/*Function to write from a register*/
int adxxx_write(struct adxxxx_descriptor *device, struct adxxxx_reg* reg, uint32_t data);
