/***************************************************************************//**
*   @file   AD1234.cpp
*   @brief  Implementation of Ad1234 Driver.
*   @author FirstName LastName (email ID)
*******************************************************************************
* Copyright 2013(c) Analog Devices, Inc.
*
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification,
* are permitted provided that the following conditions are met:
*  - Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*  - Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in
*    the documentation and/or other materials provided with the
*    distribution.
*  - Neither the name of Analog Devices, Inc. nor the names of its
*    contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*  - The use of this software may or may not infringe the patent rights
*    of one or more patent holders.  This license does not release you
*    from the requirement that you obtain separate licenses from these
*    patent holders to use this software.
*  - Use of the software either in source or binary form, must be run
*    on or directly connected to an Analog Devices Inc. component.
*
* THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* * LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
******************************************************************************/
#include "mbed.h" /*Neccessary Include Files*/
#include "ADxxxx.h"

/*Actual Declaration of all registers 
  based on the four fields declared in 
  the header file
  {Address, Value, Size, Read or Write}*/
struct adxxxx_reg adxxxx_all_regs[ADXXXX_REG_NUM] = {
    {0x00, 0x00,   1, 1}, /*EX_ADXXXX_POWER_ON*/
    {0x01, 0x00,   1, 1}, /*EX_ADXXXX_POWER_LEVEL*/    
    {0x02, 0x00,   1, 1}, /*EX_ADXXXX_CALIBRATION*/        
};

/*Function to malloc space for descriptor as well
  as start the proper serial communication
  **You should only be using either SPI or I2C at once**
  Parameters: Pointer to a pointer to the device descriptor
  Return Value: SUCCESS, FAILURE (You can make these more appropriate return 
                                  values if you would like, making it more
                                  readable)*/
int adxxxx_setup(struct adxxxx_descriptor **device, struct adxxxx_init_params init_param) {
    
    int8_t return_val = 1;
    struct adxxxx_descriptor * desc;
    extern struct adxxxx_reg adxxxx_all_regs[ADXXXX_REG_NUM];
    
    desc = (struct adxxxx_descriptor *)malloc(sizeof(*desc));
    if (!desc) 
        return FAILURE;
    
    desc->all_regs = adxxxx_all_regs;
    
    /*Example of turning the device on and calibrating
      it, but clearly this is device specific*/
    desc->is_calibrated = ADXXXX_NOT_CALIBRATED;
    desc->power_level = ADXXXX_POW_IDLE;
    
    /*Uncomment the protocol your device uses*/
    //return_val = spi_init(&desc->spi_desc, &init_params.spi_init);
    //return_val = i2c_init(&desc->i2c_desc, &init_params.i2c_init);
    if (return_val < 1) 
        return FAILURE; 
    
    *device = desc;
    return SUCCESS;     
}

/*Function to sweep through all of the registers and set them
  to their initial values
  Parameters: Pointer to adxxxx's descriptor
  Return Value: SUCCESS, FAILURE*/
int adxxxx_init_regs(struct adxxxx_descriptor *device) {
    /*Sweep through all of the registers that you initialized
      in the struct above and write all the values to the device
      (Could return register that failed to be written to may be
      helpful for debugging)*/
    return SUCCESS;    
}

/*Function to make a single or multi read from the device, based off 
  the registers size which you can find in the devices data sheet
  Parameters: Pointer to adxxxx's descriptor, register struct to read from
  Return Value: SUCCESS, FAILURE*/
int adxxx_read(struct adxxxx_descriptor *device, struct adxxxx_reg* reg) {
    /*Follow your devices specific write protocol (I2C, SPI) in conjunction 
      with the platform specific drivers to effectively communicate with your
      device (A good first step is perhaps reading your devices ID register
      or something else that is easy to get to)*/
    return SUCCESS;        
}

/*Function to make a single or multi write to the device, based off 
  the registers size which you can find in the devices data sheet
  Parameters: Pointer to adxxxx's descriptor, register struct to read from
  Return Value: SUCCESS, FAILURE*/
int adxxx_write(struct adxxxx_descriptor *device, struct adxxxx_reg* reg, uint32_t data) {
    /*Follow your devices specific write protocol (I2C, SPI) in conjunction 
      with the platform specific drivers to effectively communicate with your
      device (Try and write to a read-enabled register and then immediately
      read back the value you wrote)*/
    reg->value = data;
    return SUCCESS;    
}