/*
*Maksim Kostadinov 0358/20
*Volume control for buzzer via altering the amplitude of the square signal
*
*Uradjeno kao test, sintaksa nije efikasna i neprecizna, npr. iako bi duty cicle
*trebao da ostane 50%, zbog nacina na koji je napisano vreme koje je potrebno da
*se izlaz postavi na visoki napon, definisan polozajem pot1, je nesto vece nego vreme postavljanja izlaza na nulu.
*To je manje primetno na nizim freq, ali se jasno vidi osciloskopom na visim freq, i samim tim se smanjuje duty cycle .
*Takodje, iako je teoretski program napisan tako da stvara signal od 200 do 20000Hz, max freq koju on repreodukuje
*je 7.12kHz, pretpostavljam zbog vremena koje je potrebno za medjufunkcije.
*Ipak, Volume control ovom metodom radi ocekivano, i trunku bolje od same promene duty-cycle PWM signala.
*Moguca unapredjenja su:
*1. Nekako promeniti vrednosti sa lin pota da budu log.
*2. Proveriti na kom naponu tranzistor koji vrsi pobudu zujalice ulazi u zasicenje, postaviti da je taj napon zapravo
    max amplituda signala, bilo sta preko toga nece menjati jacinu zujalice.
*/




/*import libs*/
#include "mbed.h"

/*define macros*/


/*global vars*/

AnalogIn Pot1 (PA_0);
AnalogIn Pot2 (PA_1);
AnalogOut aout (PA_5);






/* func definitions*/

/*main func*/
double period=0.0; 
int main (){



    double max_period=4950;
    
    while(1) {
       
        period=(1.0-Pot2.read())*max_period + 50;
        aout.write(Pot1.read());
        wait_us(0.5*period);
        aout.write(0);
        wait_us(0.5*period);
        
    }
}

    
    