/*
*Maksim Kostadinov 0358/20
*Test 2
*
*U slucaju moje izvedbe programa vrednost na displeju se prikazuje ukoliko
*smo u rezimu prikazivanja vrednosti, i ta vrednost se konstantno ocitava sa
*potenciometra, tako da on prikazuje vrednost koju cujemo u tom trenutku.  
*Ukoliko se pak ovim bonus pitanjem htelo naglasiti da se potenciometar "na uvo" 
*ne ponasa linearno, onda je odgovor na pitanje da nase usi zapravo ocekuju logaritamsko
*pojacanje, a potenciometar menja linearno vrednost
*
*/




/*import libs*/
#include "mbed.h"

/*define macros*/
#define LEDa PA_10
#define LEDb PA_9
#define LEDc PA_8
#define LEDd PB_10
#define LEDe PB_5
#define LEDf PB_4
#define LEDg PB_3
#define SEL1 PB_6
#define SEL2 PC_7
#define DEBOUNCE_TIME 150
#define MULTIPLEX_TIME 10
#define BUZZ PA_11

/*global vars*/
BusOut display (LEDa,LEDb,LEDc,LEDd,LEDe,LEDf,LEDg,LED1);
DigitalOut select1 (SEL1);
DigitalOut select2 (SEL2);
AnalogIn Pot1 (PA_0);
AnalogIn Pot2 (PA_1);
PwmOut Buzzer (PA_11);
InterruptIn SW1(PC_9);


int Digit;
int showDisplay=0;
float currentNum=0;


/* func definitions*/
void ISR_sw1 (void);
void HexCoder(int decNum);
/*main func*/

int main (){
    display.write (0b11111111);
    SW1.fall(&ISR_sw1);
    
    while(1){
        currentNum=int(Pot1.read()*100);
    
    Buzzer.period(1/((19800*Pot2.read())+0200));
    Buzzer.pulsewidth((1/((19800*Pot2.read())+200))*Pot1.read()/2);
    //alternativno
    //Buzzer.write(Pot1.read()/2);
    if (showDisplay){
            select2.write(1);
            select1.write(0);
            HexCoder(int(currentNum/10));
            if(Digit==0xC0){
                display.write (0b11111111);
            }else{
                display.write(Digit);
            }
            wait_ms(MULTIPLEX_TIME);
            select2.write(0);
            select1.write(1);
            HexCoder(currentNum-(int(currentNum/10)*10));
            display.write(Digit);
            wait_ms(MULTIPLEX_TIME);
        }else{
        display.write (0b11111111);
    wait_ms(2*MULTIPLEX_TIME);
        }
    }
    
    
}

    
     void ISR_sw1(){
    showDisplay=!showDisplay;
    }
        
    void HexCoder(int decNum){
    switch (decNum){
        case 0: 

        Digit=0xC0;
        break;
        case 1: 
    
        Digit=0xF9;
        break;
        case 2: 
        Digit=0xA4;
        break;
        case 3: 
 
        Digit=0xB0;
        break;
        case 4: 

        Digit=0x99;
        break;
        case 5: 
 
        Digit=0x92;
        break;
        case 6: 
    
        Digit=0x82;
        break;
        case 7: 
     
        Digit=0xF8;
        break;
        case 8: 
   
        Digit=0x80;
        break;
        case 9: 

        Digit=0x90;
        break;
        }
}        