/*import libs*/
#include "mbed.h"

/*define macros*/
#define LEDa PA_10
#define LEDb PA_9
#define LEDc PA_8
#define LEDd PB_10
#define LEDe PB_5
#define LEDf PB_4
#define LEDg PB_3
#define SEL1 PB_6
#define SEL2 PC_7
#define DEBOUNCE_TIME 150
#define MULTIPLEX_TIME 10

/*global vars*/
BusOut display (LEDa,LEDb,LEDc,LEDd,LEDe,LEDf,LEDg,LED1);
DigitalOut select1 (SEL1);
DigitalOut select2 (SEL2);
DigitalIn Switch1 (PC_9);
DigitalIn Switch2 (PC_8);
int DecNum1;
int DecNum2;
int currentNum=0;
/* func definitions*/
void multiplexedDisplay(int decNum){
    switch (decNum){
        case 0: 
        DecNum1=0b11111111;
        DecNum2=0xC0;
        break;
        case 1: 
        DecNum1=0b11111111;
        DecNum2=0xF9;
        break;
        case 2: 
        DecNum1=0b11111111;
        DecNum2=0xA4;
        break;
        case 3: 
        DecNum1=0b11111111;
        DecNum2=0xB0;
        break;
        case 4: 
        DecNum1=0b11111111;
        DecNum2=0x99;
        break;
        case 5: 
        DecNum1=0b11111111;
        DecNum2=0x92;
        break;
        case 6: 
        DecNum1=0b11111111;
        DecNum2=0x82;
        break;
        case 7: 
        DecNum1=0b11111111;
        DecNum2=0xF8;
        break;
        case 8: 
        DecNum1=0b11111111;
        DecNum2=0x80;
        break;
        case 9: 
        DecNum1=0b11111111;
        DecNum2=0x90;
        break;
        case 10: 
        DecNum1=0xF9;
        DecNum2=0xC0;
        break;
        case 11: 
        DecNum1=0xF9;
        DecNum2=0xF9;
        break;
        case 12: 
        DecNum1=0xF9;
        DecNum2=0xA4;
        break;
        case 13: 
        DecNum1=0xF9;
        DecNum2=0xB0;
        break;
        case 14: 
        DecNum1=0xF9;
        DecNum2=0x99;
        break;
        case 15: 
        DecNum1=0xF9;
        DecNum2=0x92;
        break;
        
        } 
        
     }
/*main func*/
int main (){
    multiplexedDisplay(currentNum);
    while(1){
        if (Switch1==0 || Switch2==0){
            select1.write(1);
            select2.write(1);
            if(Switch1==0){
                currentNum+=1;
                if(currentNum==16){
                    currentNum=0;
                }
                multiplexedDisplay(currentNum);
                
            }
            if (Switch2==0){
                currentNum-=1;
                if(currentNum==-1){
                    currentNum=15;
                }
                multiplexedDisplay(currentNum);
            }
             wait_ms(DEBOUNCE_TIME);
            }
        select2.write(1);
        select1.write(0);
        display.write(DecNum1);
        wait_ms(MULTIPLEX_TIME);
        select2.write(0);
        select1.write(1);
        display.write(DecNum2);
        wait_ms(MULTIPLEX_TIME);
       
        
        }
    }