/*

Lazar Dobric 11/12/2021 23:12 EST

*/


// importing libraries
#include "mbed.h"


// macros
#define VOLTAGE_SCALER 3.3f
#define VOLTAGE_LIMIT 2.7f
#define PWM_PERIOD_MS 1
#define BUZZER_HIGH 0.9f
#define BUZZER_LOW 0    


AnalogIn pot2(PA_1);
PwmOut buzzer(PA_11);
InterruptIn sw1(PC_9);

// global
static char buzzing = 0;

// declarations
void ISR_sw1(void);

int main()
{
    
    buzzer.period_ms(PWM_PERIOD_MS);
    buzzer.write(BUZZER_LOW);
    sw1.fall(&ISR_sw1);
    
    while(true)
    {
        if(pot2.read()*VOLTAGE_SCALER >= VOLTAGE_LIMIT)
        {
            if (!buzzing)
            {
                buzzer.write(BUZZER_HIGH);
                buzzing = 1;
            }
        }
        else
        {
            buzzing = 0;
        }
        
        
    }   
    
}

// Interrupt Service Routine
void ISR_sw1(void)
{
     buzzer.write(BUZZER_LOW);
     buzzing = 0;
    
}


