//MQTT & mbed libraries
#include "mb_pins.h"
#include "mbed.h"
#include "platform/mbed_thread.h"
#include "MQTTClientMbedOs.h"
//Oled libraries
#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h"

//Macros
#define WAIT_MS 10
 
//I2C
#define I2C_ADDRESS         0x3c
#define I2C_ADD_MBED    I2C_ADDRESS << 1
#define OLED_HEIGHT_PX 64
#define OLED_WIDTH_PX 128
 
 
TCPSocket socket;
MQTTClient client(&socket);
MQTT::Message message;
WiFiInterface *wifi;
 
I2C i2c_obj(MB_OLED_SDA, MB_OLED_SCL);
Adafruit_SSD1306_I2c myOLED(i2c_obj, PB_5, I2C_ADD_MBED, OLED_HEIGHT_PX, OLED_WIDTH_PX);
 
char* topic_sub = "samo-jak-gas";
const char* hostname = "broker.hivemq.com";
int port = 1883;
 
void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Browser message: %.*s \n", message.payloadlen, (char*)message.payload);
    
    myOLED.clearDisplay();
    myOLED.setTextCursor(0, 0);
    myOLED.printf("%.*s \r", message.payloadlen, (char*)message.payload);
    myOLED.display();
}
 
int main()
{
    wifi = WiFiInterface::get_default_instance();
    
    printf("Connecting to %s... \n",MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if(ret != 0){
        printf("Greska u povezivanju");
        return -1;
    }
    printf("Success!\n");
    
    socket.open(wifi);
    socket.connect(hostname,port);
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "Zolica";
 
    client.connect(data);
    client.subscribe(topic_sub, MQTT::QOS0, messageArrived);
    
    myOLED.begin();
    i2c_obj.frequency(400000);
    
    myOLED.clearDisplay();
    myOLED.display();
    
    
    while(1) {
        thread_sleep_for(WAIT_MS);
        client.yield(1000);
    }
}