/*
Lazar Dobric 2020/0712 09:57 11/13/2021
TEST 2


odgovor na bonus:
"Da li prikazana vrednost na displeju odgovara onome što se može čuti?"
U mom slucaju, da. Ogranicio sam da cim potenciometar predje vrednost ciji je ekvivalent u procentima 90%, sama jacina zvuka bude na 90%(90% je duty cycle).
U opstem slucaju, ne odgovara jer kada ispunjenost periode signala koji dovodimo na buzzer predje 96-97%, buzzer nece stici da se u toku periode ugasi da bi ostvario piezoelektricni efekat
na cijem principu i radi. Zato kada bi presli tih 96-97% periode, ne bismo culi nista.
*/


//uvoz biblioteka
#include "mbed.h"
#include "math.h"


// definisanje direktiva
#define LOW_PWM_PERIOD_US 5000
#define HIGH_PWM_PERIOD_US 50
#define A PA_10
#define B PA_9
#define C PA_8
#define D PB_10
#define E PB_5
#define F PB_4
#define G PB_3
#define SEL_1 PB_6
#define SEL_2 PC_7
#define SW1 PC_9

// globalne promenljive(objekti)
static char updateDisplay = 0;
const int digit[] = {0b1000000, 0b1111001, 0b0100100, 0b0110000, 0b0011001, 0b0010010, 0b0000010, 0b1111000, 0b0000000, 0b0010000/*, 0b1111111*/};
AnalogIn pot1(PA_0);
AnalogIn pot2(PA_1);
PwmOut buzzer(PA_11);
InterruptIn sw1(SW1);
BusOut display(A,B,C,D,E,F,G);
DigitalOut select1(SEL_1);
DigitalOut select2(SEL_2);

// deklaracije funkcija
void ISR_sw1(void);

int main()
{
    // flegovi i inicijalizacija
    static float volume = 0;
    int digit1 = 0;
    int digit2 = 0;
    buzzer.period_us(LOW_PWM_PERIOD_US);
    buzzer.write(0);
    select2.write(1);
    select1.write(1);
    
    // azuriranje displeja usled pritiska sw1
    sw1.fall(&ISR_sw1);
    
    
    
    while(true)
    {
        volume = pot1.read();
        printf("Volume: %f\n", volume*100);
        if(volume > 0.9)
        {
            buzzer.write(0.9);
        }
        else if( volume < 0.05)
        {
            buzzer.write(0);
        }
        else
        {
        buzzer.write(volume);
        }
        
        buzzer.period_us(LOW_PWM_PERIOD_US * (1 - pot2.read()));
        
        //wait_us(1);
        

        
        if(updateDisplay)
        {
            digit2 = int(volume*100) % 10;
            digit1 = int(volume*100) / 10;
            updateDisplay = 0;
        
        }
        else
        {
            updateDisplay = 0;
        }
        
        if(digit1 == 0)
        {
            select1.write(1);
            select2.write(0);
            display = digit[digit2];
            wait_ms(20);
        }
            
        if(digit1 > 0)
        {
            select2.write(1);
            select1.write(0);
            display = digit[digit1];
            printf("Digit1: %d\n", digit1);
            //wait_us(10);
            select1.write(1);
            select2.write(0);
            display = digit[digit2];
            printf("Digit2: %d\n", digit2);
            //wait_us(10);
        }
        

    }   
    
}

// Prekidna rutina
void ISR_sw1(void)
{
     updateDisplay = 1;
    
}
