#ifndef MBED_PS3PAD_H
#define MBED_PS3PAD_H

/*
リモコンのボタン宣言
構造体
ps.------left_x
    |  |-left_y
    |  |-right_x
    |  |-right_y
    |
    |--BUTTON.-----BIT.
               |    |-UP
               |    |-RIGHT
               |    |-DOWN
               |    |-LEFT
               |    |-SANKAKU
               |    |-MARU
               |    |-BATU
               |    |-SIKAKU
               |    |-L1
               |    |-R1
               |    |-SELECT
               |    |-START
               |    |-HOME
               |
               |--ANALOG.
                    |-L2
                    |-R2
*/

class PS3pad
{
public:
    PS3pad(PinName sda, PinName scl, int addr);
    struct{
        struct{
            uint8_t UP,RIGHT,DOWN,LEFT,SANKAKU,MARU,BATU,SIKAKU,L1,R1,SELECT,START,HOME;
        }BIT;
        struct{
            uint8_t L2,R2;
        }ANALOG;
    }BUTTON;
    int8_t left_x,left_y,right_x,right_y;
    void getValues(void);
    
private:
    char get[8];
    I2C ds3com;
    int ADDR;
};


#endif /* PSPAD_H_ */
