#include "mbed.h"
#include "PS3pad.h"

/*
I2C通信をやっています
宣言方法：PS3pad name(SDA, SCL, Arduino_addrece);
ボタン使用方法：#define NAME name.BUTTON.BIT.MARU    丸ボタンの場合
             NAMEに値が格納される
リモコン値取得方法：name.getValues();
                その後、値を使えるようになる
*/

PS3pad::PS3pad(PinName sda, PinName scl, int addr) : ds3com(sda,scl){
        ds3com.frequency(400000);
        ADDR = (addr << 1);
        
        memset(get,0,8);
}


void PS3pad::getValues(void){
        int i=0;
        
        for(i=0;i<2;i++){get[i]=0;}
        for(i=2;i<5;i++){get[i]=127;}
        for(i=6;i<8;i++){get[i]=0;}
        
        ds3com.read(ADDR, get, 8);
        
        BUTTON.BIT.UP = get[0] >> 7;
        BUTTON.BIT.RIGHT = (get[0] >> 6)-((get[0] >> 7) << 1);
        BUTTON.BIT.DOWN = (get[0] >> 5)-((get[0] >> 6) << 1);
        BUTTON.BIT.LEFT = (get[0] >> 4)-((get[0] >> 5) << 1);
        BUTTON.BIT.SANKAKU = (get[0] >> 3)-((get[0] >> 4) << 1);
        BUTTON.BIT.MARU = (get[0] >> 2)-((get[0] >> 3) << 1);
        BUTTON.BIT.BATU = (get[0] >> 1)-((get[0] >> 2) << 1);
        BUTTON.BIT.SIKAKU = (get[0])-((get[0] >> 1) << 1);
        BUTTON.BIT.L1 = (get[1] >> 7);
        BUTTON.BIT.R1 = (get[1] >> 6)-((get[1] >> 7) << 1);
        BUTTON.BIT.SELECT = (get[1] >> 5)-((get[1] >> 6) << 1);
        BUTTON.BIT.START = (get[1] >> 4)-((get[1] >> 5) << 1);
        BUTTON.BIT.HOME = (get[1] >> 3)-((get[1] >> 4) << 1);
        left_x = get[2]-128;
        left_y = -(get[3]- 128+1);
        right_x = get[4]-128;
        right_y = -(get[5]- 128+1);
        BUTTON.ANALOG.L2 = get[6];
        BUTTON.ANALOG.R2 = get[7];
        
        wait_ms(10);
}
