#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 115200 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX, 115200);
DigitalOut led_red((PinName)LED_RED, (int)0);//高电平点亮,低电平熄灭
DigitalIn user_button((PinName)USER_BUTTON, (PinMode)PullUp);
AnalogIn analog_value(A0);
PwmOut mypwm(PWM_OUT);

Ticker read_analog_ticker;

void read_analog_value()
{
    float meas = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    meas = meas * 3300; // Change the value to be in the 0 to 3300 range
    pc.printf("measure = %.0f mV\r\n", meas);
}

int main(void)
{
    pc.printf("\nAnalogIn example\r\n");

    mypwm.period_ms(10);
    mypwm.pulsewidth_ms(1);
    printf("pwm set to %.2f %%\n", mypwm.read() * 100);

    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
    read_analog_ticker.attach(&read_analog_value, 1);

    while (1) {
        if (0  == user_button) {
            led_red.write(1);
        } else
            led_red.write(0);
        wait(0.1); // 100 ms
    }
}
