#include "ACS712.h"

ACS712::ACS712() : sensor(SENSOR_PIN),
                   currentSwitch(SWITCH_PIN)
{
    currentSwitch = 1;      //turn off the currentSwitch (1 = off, 0 = on)
    m = 0;
    b = 0;
}

void ACS712::calibrate(){
    float V1,V2,A1,A2;
    A1 = LOW_CURRENT;
    A2 = HIGH_CURRENT;
    
    currentSwitch = 1;
    wait_ms(100);
//wait_ms(5000);//MARK
    V1 = read_sensor(CALIBRATION_SAMPLES,10);

    currentSwitch = 0;
    //Thread::wait(100);
//wait_ms(5000);//MARK
    wait_ms(100);
    V2 = read_sensor(CALIBRATION_SAMPLES,10);
    currentSwitch = 1;
    m = (A2-A1)/(V2-V1);
    b = A1 - V1*m;
}
float ACS712::get_current(){
    return m*read_sensor(10,0) + b;
}
float ACS712::read_sensor(){
    sensor_val = sensor.read();
    return sensor_val;
}
float ACS712::read_sensor(int n, int t){
    sensor_val = 0;
    for(int i = 0; i<n; i++){
        sensor_val += sensor.read();
        wait_ms(t);
        //Thread::wait(10);
    }
    sensor_val = sensor_val/float(n);
    return sensor_val;
}