#ifndef RECKON_H
#define RECKON_H

#include "mbed.h"
#include "ADNS5090.h"

//TODO: include a function to swap motors if they are connected wrong.

#define DEGREES(radians)((radians)*180/M_PI)

class Reckon
{
    public:
    
    ADNS5090&   optical_flow_L;
    ADNS5090&   optical_flow_R;    
    float r;
    
    float x;
    float y;
    float accX;
    float accY;
    float accZ;
    
    float flowX;
    float flowY;
    float flowYaw;
    float flow_dx_L;
    float flow_dx_R;
    float flow_dy_L;
    float flow_dy_R;
    float gyroYaw;
    
    Reckon(ADNS5090& L,ADNS5090& R, float radius);    
    
    static float reduce_angle( float &);
    
    float dest_angle(float x_dest, float y_dest);
    float dest_distance(float x_dest, float y_dest);
    
    bool updateOpticalFlow();               //new
    void reset();     
    
    private:    
    Timer frametime;
};

#endif