#ifndef ROBOT_H
#define ROBOT_H

#include "mbed.h"
#include "rtos.h"
#include "stdint.h"

#include "HC05.h"
#include "nRF24L01P.h"

#include "MPU6050_6Axis_MotionApps20.h"
#include "MPU6051_6Axis_MotionApps20.h"
#include "DMP.h"
#include "IMUDATA.h"
#include "ADNS5090.h"
#include "ACS712.h"
#include "Servo.h"

#include "reckon.h"
#include "motors.h"

#define write_rate      100      //Maximum write rate (ms) of the motor

#define BT_BAUD_RATE        115200        //Baud rate of 9600
#define TX_BT               PTA2        //Bluetooth connection pins
#define RX_BT               PTA1        //Bluetooth connection pins
#define EN_BT               PTE30        //Bluetooth connection pins

#define MOSI_MOUSE          PTB16        //Bluetooth connection pins
#define MISO_MOUSE          PTB17        //Bluetooth connection pins
#define SCLK_MOUSE          PTB11        //Bluetooth connection pins
#define NCS_MOUSE_L         PTB9        //Bluetooth connection pins
#define NCS_MOUSE_R         PTB8        //Bluetooth connection pins

//#define IMU_SDA_PIN         PTE0
//#define IMU_SCL_PIN         PTE1
#define IMU_POWER_PIN       PTD6
#define IMU2_POWER_PIN      PTD4 //PTD4
//#define IMU_NOTUSED_PIN     PTE23

#define LED_PIN     PTE3        //status LED pin
#define LED_OFF  led = 1;        //status LED pin
#define LED_ON   led = 0;        //status LED pin

//#define CURRENTSENSOR_PIN PTC2
#define VOLTAGESENSOR_PIN PTB0
//#define HIGH_CURRENT_SWITCH PTB18   //turn this to high to get high current flow


//#define CURRENT_R1 180 //160.0     //values of the current sensor opamp resistors
//#define CURRENT_R2 10
//#define CURRENT_R3 80
//#define CURRENT_R4 84.7
//#define VREF3_3 3.3        //digital logic voltage
//#define VREF5 5.0       //5v voltage        //NOTE: 5v voltage is consistent when using new batts, but not using old blue batts

#define IR_L PTB1
#define IR_C PTB2
#define IR_R PTB3
#define IR_B PTC6     //turn GPIO to high to multiplex L,C,R ADC to rear sensors


#define MOT_AIN1_PIN   PTA14
#define MOT_AIN2_PIN   PTA13
#define MOT_PWMA_PIN   PTA4    //Motor control pins  

#define MOT_BIN1_PIN   PTA16
#define MOT_BIN2_PIN   PTA17
#define MOT_PWMB_PIN   PTA5

#define MOT_STBY_PIN   PTA15

//used for RF device
#define TRANSFER_SIZE   4
#define ROBOT1_ADDRESS      ((unsigned long long) 0x17E7E7E7E7 )
#define ROBOT2_ADDRESS      ((unsigned long long) 0xC2C2C2C2C2 )
#define ROBOT3_ADDRESS      ((unsigned long long) 0x37E7E7E7E7 )
#define ALLROBOT_ADDRESS    ((unsigned long long) 0xE7E7E7E7E7 )
#define ADDRESS_WIDTH       5
const float M_PI = 3.14159265;

extern DigitalOut led;
extern Servo myservo;

extern HC05 bt;

extern bool send_flag;
extern bool obstacle_flag;   //this alerts the robot if there is an obstacle somewhere. 
extern bool fwd_flag;   //indicates that the robot is trying to move forward
extern bool calibrate_flag;
extern bool calibrate_optFlow_flag;

extern AnalogIn irL;
extern AnalogIn irC;
extern AnalogIn irR;
extern DigitalOut irBack;
extern AnalogIn voltage_sensor;

extern ACS712 current_sensor;
extern ADNS5090 opt_flow_L;
extern ADNS5090 opt_flow_R;

extern MPU6050 mpu;
extern MPU6051 mpu2;

extern DigitalOut imuSwitch;
extern DigitalOut imu2Switch;
extern IMU_DATA imu_data;
extern IMU_DATA imu2_data;

extern Reckon  reckon;

extern Motors motors;
extern RtosTimer *MotorStopTimer;

extern nRF24L01P rf;    // RF communication device

extern unsigned long long long_time;
extern Timer t;
//extern Timer t_m; //Timer used for the motor thread
extern time_t prev; //previous time for motor
float getTime();

void initRobot();
void moveMotors(int Lspeed, int Rspeed, int ms);

#endif