/** This file contains the keybindings/commands for the python interface
**/

#ifndef KEYBINDINGS_H
#define KEYBINDINGS_H

#define CONNECTION  '?'     //leave this as question mark. Returns confirmation of connection when sent
#define END_CONNECTION '$'  //end connection

//sensors
#define ALL_SENSOR  'A'     //returns all sensor data: 
#define IMU_READ    'i'     //returns the IMU data in the form XXX.XXX,YYY.YYY,ZZZ.ZZZ,xxx.xxx,yyy.yyy.zzz.zzz [m/s2],[rad/s]
#define IMU_YAW     'Y'     //returns only the YAW
#define IMU_CALIBRATE 'U'   //calibrates IMU
#define OPT_CALIBRATE 'u'   //calibrate optical flow

#define IR_READ     'I'     //returns the IR sensor data in the form 000.000,000.000... [cm] for the 5 IR sensors
#define IR_1        'L'    //left IR
#define IR_2        'C'     //right IR
#define IR_3        'R'     //centre IR
#define IR_4        'r'     //rear right IR
#define IR_5        'l'     //rear left IR

#define CURRENT_SENSE 'c'   //returns current [mA]
#define OPT_READ    'O'     //returns the velocity of each optical flow sensor X1,Y1,x2,y2 [pixels per second]
#define LOCATION    'q'     //returns the current (x,y) location of robot [cm] (needs to be implemented)

//commands
//#define IMU_CTRL    'q'     //Toggle the IMU to keep the robot driving straight
#define MOTOR_R     'd'     //Command to run right motor
#define MOTOR_L     'a'     //Command to run left motor
#define MOTOR       'w'     //Command to run both motors - specify both speeds

//#define MOTOR_FWD   'W'     //Command to run both motors straight forward
//#define ROTATE      'A'     //Command to rotate by specified rotation [degrees]

#define MOTOR_STOP  's'     //Command to stop both motors
#define GO_TO       'G'     //Command robot to go to specified coordinate

#endif