/***************************************************************************//*
 * @file    app_config.h
 * @brief   Configuration file of AD7124 firmware example program
 * @details
******************************************************************************
 * Copyright (c) 2021 Analog Devices, Inc. All Rights Reserved.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
******************************************************************************/

#ifndef APP_CONFIG_H_
#define APP_CONFIG_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include <stdint.h>
#include <PinNames.h>

/******************************************************************************/
/********************** Macros and Constants Definition ***********************/
/******************************************************************************/

/* Supported AD7124 devices (One selected at a time) */
//#define		AD7124_4
#define		AD7124_8

#if defined(AD7124_4)
#define ACTIVE_DEVICE	"AD7124-4"
#elif defined(AD7124_8)
#define ACTIVE_DEVICE	"AD7124-8"
#else
#define ACTIVE_DEVICE	"AD7124-4"
#warning "No active device selected. AD7124-4 is assumed as default"
#endif

/**
  The ADI SDP_K1 can be used with either arduino headers
  or the 120-pin SDP connector found on ADI evaluation
  boards. The default is the SDP connector.

  Uncomment the ARDUINO #define below to enable the ARDUINO connector
*/

#define  ARDUINO

// Pin mapping of AD7124 w.r.t SDP-K1/Arduino
#ifdef ARDUINO
#define SPI_SS		D10		// SPI_CS
#define SPI_MOSI	D11		// SPI_MOSI
#define SPI_MISO	D12		// SPI_MISO
#define SPI_SCK		D13		// SPI_SCK
#else
#define SPI_SS		SDP_SPI_CS_A	// PB_9
#define SPI_MISO	SDP_SPI_MISO	// PF_8
#define SPI_MOSI	SDP_SPI_MOSI	// PF_9
#define SPI_SCK		SDP_SPI_SCK		// PH_6
#endif

/******************************************************************************/
/********************** Public/Extern Declarations ****************************/
/******************************************************************************/

#endif /* APP_CONFIG_H_ */
