/*****************************************************************************
 *   @file   app_config.h
 *
 *   @brief  Configuration file of AD5770R firmware example program
******************************************************************************
 *
Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.

This software is proprietary to Analog Devices, Inc. and its licensors.
By using this software you agree to the terms of the associated
Analog Devices Software License Agreement.
 ******************************************************************************/

#ifndef APP_CONFIG_H_
#define APP_CONFIG_H_

// #includes
#include <stdint.h>
#include <PinNames.h>

// #defines

/**
  The ADI SDP_K1 can be used with either arduino headers
  or the 120-pin SDP connector found on ADI evaluation
  boards. The default is the SDP connector.

  Uncomment the ARDUINO #define to enable the ARDUINO connector
*/

//#define  ARDUINO

// Pin mapping of AD5770R with SDP-K1/Arduino
#ifdef ARDUINO
#define SPI_SS		D10		// SPI_CS
#define SPI_MISO	D11		// SPI_MOSI
#define SPI_MOSI	D12		// SPI_MISO
#define SPI_SCK		D13		// SPI_SCK
#define HW_LDACB        D2
#else
#define SPI_SS	        SDP_SPI_CS_A	// PB_9
#define SPI_MISO	SDP_SPI_MISO	// PF_8
#define SPI_MOSI	SDP_SPI_MOSI	// PF_9
#define SPI_SCK		SDP_SPI_SCK	// PH_6
#define HW_LDACB        SDP_GPIO_0      // PJ_0
#endif

// Global Variables

// Function Prototypes

#endif /* APP_CONFIG_H_ */
