// TCP test of LINAC MO Monitor
// Hengjie Ma
// BNL, NSLS-II, RF
// Nov. 2, 2017
//
#include "mbed.h"
#include "EthernetInterface.h"
#include "TextLCD.h"
#include <stdio.h>

// set TCP parameters
#define ECHO_SERVER_PORT   7
#define MAC_ADDRESS        {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02}

DigitalOut myled(LED1);  // on-board blue LED, an idiot light for TCP sanity check
char lcd_buffer[20];

// set up 2004 LCD display panel, 4-bit production wiring
// RS, E, D4-D7, LCDType=LCD16x2, BL=NC, E2=NC, LCDTCtrl=US2066
TextLCD lcd(P9, P10, P5,P8, P7, P6, TextLCD::LCD20x4D, NC, NC, TextLCD::US2066_3V3); 

int buffer_length = 256;
int compare_strings(char [], char []); 

int main (void) 
{
    myled = 1; // LED OFF in WIZwiki-W7500
    int flag=1;
    lcd.cls();
    printf("Wait a second...\r\n"); 
    lcd.printf("Wait a second...\r\n"); 
    // TCP initialization
    uint8_t mac_addr[6] = MAC_ADDRESS;
    EthernetInterface eth;
    eth.init(mac_addr);       //Use DHCP
    eth.connect();
    // annouce DHCP set echo-sever IP address
    printf("Server IP Address is %s\r\n\n", eth.getIPAddress());
    lcd.locate(0,0);
    lcd.printf("ServerIP:%s\r\n", eth.getIPAddress());
    // command for LED turn-on/off
    printf("Usage: \r\n  Client command to turn on  LED: LED_ON \r\n");
    printf("  Client command to turn off LED: any other string. \r\n\n");
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();  
    while(true)
    {
        printf("Wait for new connection...\r\n"); 
        lcd.locate(0,3); 
        lcd.printf("Wait for connect...");  
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 3000); // Timeout after (3)s
        printf("Connect from: %s\r\n", client.get_address());
        lcd.locate(0,3);
        lcd.printf("Connect:%s", client.get_address());
        char buffer[buffer_length];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            // print received message to terminal
            buffer[n] = '\0';
            printf("Received message from Client :'%s'\r\n",buffer);
            lcd.locate(0,1);
            memcpy(lcd_buffer, buffer, 20);
            lcd.printf("Client msg:'%s'\r",lcd_buffer);
          
            // LED control if received message matches pre-defined command
            /*
            if ((buffer[0] == 'L') & (buffer[1] == '\0'))
              myled = 0; // LED ON in WIZwiki-W7500
            else
              myled = 1;
            */
                     
            // LED control if received message matches pre-defined command
            char command_buf[256] = {'L', 'E', 'D', '_', 'O', 'N', '\0'};

            // char string[256];
            // strcpy (string, command_buf);
            // printf("Is received command : %s  ??? \r\n", string);
            flag = compare_strings(buffer, command_buf);
            
            if (flag == 0) {
              myled = 0; // LED ON in WIZwiki-W7500
              printf("Yes, command = LED_ON, LED is turned on!\r\n\n");
            }
            else {
              myled = 1;
              printf("No, command does not match, LED is turned off!\r\n\n");
            }
            // LED blink one time                        
            //myled = 0; // LED ON in WIZwiki-W7500
            //wait(1.0);
            //myled = 1; // LED OFF in WIZwiki-W7500
            
            // reverse the message
            char temp;
            for(int f = 0, l = n-1; f<l; f++,l--){
                temp = buffer[f];
                buffer[f] = buffer[l];
                buffer[l] = temp;
                }
            // print reversed message to terminal
            printf("Sending reversed message to Client: '%s'\r\n",buffer);
            memcpy(lcd_buffer, buffer, 20);
            lcd.locate(0,2);
            lcd.printf("ServerEcho:'%s'",lcd_buffer);
            //          123456789abcdef1234
            // Echo received message back to client
            client.send_all(buffer, n);
            if (n <= 0) break;
        }      
        client.close();
    }
}

int compare_strings(char a[], char b[])
{
   int c = 0;
 
   while (a[c] == b[c]) {
      if (a[c] == '\0' || b[c] == '\0')
         break;
      c++;
   }
 
   if (a[c] == '\0' && b[c] == '\0')
      return 0;
   else
      return -1;
}
