// Test of ADC, and LED/LCD control of LINAC MO Monitor
// Hengjie Ma
// BNL, NSLS-II, RF
// Nov. 2, 2017
//
#include "mbed.h"
#include "TextLCD.h"
#include <stdio.h>

// Analog signal input channel gain scalling
#define AIN_cal_CL1           1.0;             // RFIN_500M
#define AIN_cal_CL2           1.0;             // SPB_500M
#define AIN_cal_CL3           1.0;             // GUN_500M
#define AIN_cal_CL4           1.0;             // PB_3G
#define AIN_cal_CL5           1.0;             // K1_3G
#define AIN_cal_CL6           1.0;             // K2_3G
#define AIN_cal_OP1           1.0;             // K3_3G
#define AIN_cal_OP2           1.0;             // 5V_OK
#define AIN_cal_OP3           1.0;             // 15V_OK
#define AIN_cal_OP4           1.0;             // AIN3_SPARE
#define AIN_cal_OP5           1.0;             // AIN6_SPARE
#define AIN_cal_OP6           1.0;             // AIN7_SPARE

const char * msg[] = {
    "RFIN500M ",
    "SPB500M  ",
    "GUN500M  ",
    "PB_3G    ",
    "K1_3G    ",
    "K2_3G    ",
    "K3_3G    ",
    "5V_OK    ",
    "15V_OK   ",
    "AIN3_xxx ",
    "AIN6_xxx ",
    "AIN7_xxx " 
};

char trailer[16] = "me too !!!";    // test string

// I/O pin assignment
DigitalOut myled(LED1);  // on-board blue LED, an idiot light for TCP sanity check
// Primary group of analog inputs 
AnalogIn   AIN0(P30);    // AIN0, RFIN_500M/K3_3G
AnalogIn   AIN1(P29);    // AIN1, SPB_500M/5V_OK
AnalogIn   AIN2(P28);    // AIN2, GUN_500M/15V_OK
AnalogIn   AIN3(P27);    // AIN3, PB_3G/AIN3_SPARE
AnalogIn   AIN6(P26);    // AIN6, K1_3G/AIN6_SPARE
AnalogIn   AIN7(P25);    // AIN7, K2_3G/AIN7_SPARE
DigitalOut MUX_CTL(P11); // PA11, 

// TextLCD lcd(P9, P10, P5,P6, P7, P8, TextLCD::LCD20x4D, NC, NC, TextLCD::US2066_3V3);  // RS, E, D4-D7, LCDType=LCD16x2, BL=NC, E2=NC, LCDTCtrl=US2066
TextLCD lcd(P9, P10, P5,P8, P7, P6, TextLCD::LCD20x4D, NC, NC, TextLCD::US2066_3V3);  // RS, E, D4-D7, LCDType=LCD16x2, BL=NC, E2=NC, LCDTCtrl=US2066
float meas[12];
int idx, row, col;

void adc()
{
    // Update data 
    MUX_CTL = 0;   // group 1
    meas[0]  = AIN0.read() * AIN_cal_CL1; 
    meas[1]  = AIN1.read() * AIN_cal_CL2; 
    meas[2]  = AIN2.read() * AIN_cal_CL3;
    meas[3]  = AIN3.read() * AIN_cal_CL4;     
    meas[4]  = AIN6.read() * AIN_cal_CL5; 
    meas[5]  = AIN7.read() * AIN_cal_CL6;     
    MUX_CTL  = 1;   // group 2
    meas[6]  = AIN0.read() * AIN_cal_OP1; 
    meas[7]  = AIN1.read() * AIN_cal_OP2; 
    meas[8]  = AIN2.read() * AIN_cal_OP3;
    meas[9]  = AIN3.read() * AIN_cal_OP4;     
    meas[10] = AIN6.read() * AIN_cal_OP5; 
    meas[11] = AIN7.read() * AIN_cal_OP6;  
}

void display()
{  
    // update 20x4 LED/LCD display,  rolling  
    lcd.cls();
    for ( idx = 0; idx < 12; idx++)
    { 
        // lcd.locate(col,row); 
        printf("%s %.2f V \r\n", msg[idx], meas[idx]);      // serial console
        lcd.printf("%s %.2f V \r\n",msg[idx], meas[idx]);   // LCD/LED
        wait(0.1);           // per line
        if (row < 3)
            {
                row = row + 1;
                lcd.locate(col,row);
            }
        else
        {
            row = 0;
            wait(1.0);       // pause after each frame of 4 lines
            lcd.cls();
        }
    }
    // wait(1.0);           // every 4-screen, 12-line total, refresh 
}

int main (void) 
{
    row = 0;
    col = 0;
    printf("Test of ADC and LCD .....\r\n"); 
    while(true)
    {
        // get new data
        adc();
        // display on serial terminal and LCD
        display();
    }
}


