#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "string"
#include "threeAxis.h"
//#define stepToInch 0.0006723474
//#define stepToInch 0.0007925725
//#define maxX 11.5
//#define maxY 6.75
//#define maxZ 1.75

//Enable is active low.

//xStep, yStep, zStep, xDir, yDir, zDir, xEnable, yEnable, zEnable, stepRatio, xBound, yBound, zBound, xLimit, yLimit, zLimit
threeAxis table(p23, p25, p21, p24, p26, p22, p19, p18, p20, 0.0007925725, 11.5, 6.75, 1.75, p12, p14, p16);

DigitalOut xLimit(p13);
DigitalOut yLimit(p15);
DigitalOut zLimit(p17);

//DigitalOut zStep(p21);
//DigitalOut zEnable(p20);
//DigitalOut zDir(p22);

//DigitalOut xEnable(p19);
//DigitalOut xStep(p23);
//DigitalOut xDir(p24);

//DigitalOut yEnable(p18);
//DigitalOut yStep(p25);
//DigitalOut yDir(p26);


Serial bluetooth(p28,p27);
uLCD_4DGL uLCD(p9,p10,p11);
DigitalOut actualLED(LED1);
Mutex LCD;
bool buffering;
/*
volatile int currX;
volatile int currY;
volatile int currZ;
volatile int toX;
volatile int toY;
volatile int toZ;
*/
Thread thread;
Thread thread2;

void raiseLimit(DigitalOut* arg){
        while(1){
            if(bluetooth.readable()){
                char temp;
                while(bluetooth.readable()){
                    temp = bluetooth.getc();
                }
                //bluetoothFlush();
                *arg = 1;
                break;
            }
        }
}

void bluetoothFlush(){
    char temp;
    while(bluetooth.readable()){
        temp = bluetooth.getc();
    }
}

void parseCoords(std::string coords){    
    
    int start = 0;
    int end = coords.find(',');
    

    float tempX = atof(coords.substr(start, end-start).c_str());

    
    start = end + 1;
    end = coords.find(',', start);

    float tempY = atof(coords.substr(start, end-start).c_str());
    
    start = end + 1;
    end = coords.length();
    float tempZ = atof(coords.substr(start, end-start).c_str());
    
    if(!buffering){
        table.goTo(tempX, tempY, tempZ);
    }
    else{
        table.addToBuffer(tempX, tempY, tempZ);
    }
    
}

void bluetooth_thread(){
    
    
    //char bnum=0;
    while(1) {
        std::string coords = "";
        Thread::wait(100);
        
        if (bluetooth.readable()){
            LCD.lock();
            uLCD.cls();
            LCD.unlock();
            while (bluetooth.readable()){
                
                char temp = bluetooth.getc();
                
                if (temp == 'z'){
                    table.setZero();
                }
                else if(temp == 'b'){
                    buffering = !buffering;
                }
                else if(temp == 'e'){
                    table.setLimits(!table.getLimitsEn());
                }
                
                coords += temp;
            }
        
            //Thread::wait(1000);
        LCD.lock();
        if ((coords.find('z') == -1) && (coords.find('b') == -1) && (coords.find('e') == -1)){                
             uLCD.printf(coords.c_str());
             LCD.unlock();
             parseCoords(coords);
                
        }
        else{
                
             if (coords.find('z') != -1){
                 uLCD.printf("Zeroed!");
                 LCD.unlock();
             }
             else if (coords.find('b') != -1){
                 if (buffering){
                     uLCD.printf("Now buffering!");
                     LCD.unlock();
                 }
                 else if (!buffering){
                     uLCD.printf("Running buffer!");
                     LCD.unlock();
                     table.runBuffer();
                 }
             }
             else if (coords.find('e') != -1){
                 if (table.getLimitsEn()){
                     uLCD.printf("Limits enabled!");
                     LCD.unlock();
                 }
                 else if (!table.getLimitsEn()){
                     uLCD.printf("Limits disabled!");
                     LCD.unlock();
                     table.runBuffer();
                 }
             }
        }
    }
        
        
}

}


int main() {
    //Y axis direction inverted from others to get behavior that makes me happy (rewards = negative, forward = positive)
    table.invertY();
    table.invertZ();
    table.setWait(3);
    uLCD.baudrate(300000);
    wait(0.5);
    
    
    //I'm going to be honest, my understanding of my own code means that ANY character should start the zero'ing process, and that nothing should skip it
    //As such its technically a bug that it skips zeroing a given axis if something is entered
    //However, I like this functionality more than what I intended
    //So I'm labeling the "bug" as a feature
    LCD.lock();
    uLCD.printf("Enter null value to begin X zero, anything else to skip");
    //LCD.unlock();
    while(1){
        if(bluetooth.readable()){
            bluetoothFlush();
            break;
        }
    }
    //LCD.lock();
    uLCD.printf("\n");
    uLCD.printf("Enter null to stop");
    LCD.unlock();
    
    thread2.start(raiseLimit,&xLimit);
    Thread::wait(50);
    table.zeroX();

    LCD.lock();
    uLCD.cls();    
    uLCD.printf("Enter null value to begin Y zero, anything else to skip");
    LCD.unlock();
    
    while(1){
        if(bluetooth.readable()){
            bluetoothFlush();
            break;
        }
    }
    
    LCD.lock();
    uLCD.printf("\n");
    uLCD.printf("Enter null to stop");
    LCD.unlock();
    
    thread2.start(raiseLimit,&yLimit);
    Thread::wait(50);
    table.zeroY();
    
    LCD.lock();
    uLCD.cls();    
    uLCD.printf("Enter null value to begin Z zero, anything else to skip");
    LCD.unlock();
    
    while(1){
        if(bluetooth.readable()){
            bluetoothFlush();
            break;
        }
    }
    
    LCD.lock();
    uLCD.printf("\n");
    uLCD.printf("Enter null to stop");
    LCD.unlock();
    
    
    thread2.start(raiseLimit,&zLimit);
    Thread::wait(50);
    table.zeroZ();
    
    thread2.terminate();
    LCD.lock();
    uLCD.cls();
    
    table.setLimits(true);
    xLimit = 0;
    yLimit = 0;
    zLimit = 0;
        
    uLCD.printf("Waiting...");
    LCD.unlock();
    
    bluetoothFlush();
    
    thread.start(bluetooth_thread);
    
    while(1);
}
