class threeAxis{
    public:
        threeAxis(PinName xStep, PinName yStep, PinName zStep, PinName xDir, PinName yDir, PinName zDir, PinName xEnable, PinName yEnable, PinName zEnable, float stepRatio, float xBound, float yBound, float zBound, PinName xLimit, PinName yLimit, PinName zLimit);
        void goTo(float xVal, float yVal, float zVal);
        
        void addToBuffer(float xVal, float yVal, float zVal);
        void runBuffer();
        
        void stepBackX();
        void stepBackY();
        void stepBackZ();
        
        void setZero();
        
        void setZeroX();
        void setZeroY();
        void setZeroZ();
        
        void zeroX();
        void zeroY();
        void zeroZ();
        
        void setWait(int waitPer);
        
        void setXdir(bool val);
        void setYdir(bool val);
        void setZdir(bool val);
        
        void invertX();
        void invertY();
        void invertZ();
        
        void setLimits(bool val);
        bool getLimitsEn();
        
    protected:
        int toX;
        int toY;
        int toZ;
        
        int currX;
        int currY;
        int currZ;
        
        DigitalOut _xStep;
        DigitalOut _yStep;
        DigitalOut _zStep;
        
        DigitalOut _xDir;
        DigitalOut _yDir;
        DigitalOut _zDir;
        
        DigitalOut _xEnable;
        DigitalOut _yEnable;
        DigitalOut _zEnable;
        
        DigitalIn _xLimit;
        DigitalIn _yLimit;
        DigitalIn _zLimit;
        
        float _stepRatio;
        
        float _xMax;
        float _yMax;
        float _zMax;
        
        bool limitsEnabled;
        
        bool defaultXdir;
        bool defaultYdir;
        bool defaultZdir;
        
        int wait;
        
        int bufferIndex;
        float buffer[][3];
};