/*##########################################################################################

Program Name    : ex1_HC06_leds
Author          : Grant Phillips
Date Modified   : 12/05/2016
Compiler        : ARMmbed
Tested On       : STM32F4-Discovery
Discription     : I used some of the program to develop mine Elecrtonic Householder Water Meter
##############################################################################################*/
///////////////////////DECLARING LIBRIES////////////////////////////////////////////////////////

#include "mbed.h"
//////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////DECLARING BLUETOOTH MODULE PINS//////////////////////////////////////////////////////

Serial bt(PC_10, PC_11);      //create a Serial object to connect to the HC05 Bluetooth module
//        tx  , rx 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////DECLARING SOLAR PANEL TRANSISTOR'S OPARATIONAL PINS///////////////////////////////////////////////////////////////////////////////////

DigitalOut Q1(PA_10);       // Solar Panel Forward bias (Q1)transistor for the posistive leg
DigitalOut Q2(PB_3);        // Solar Panel Voltage testing loop forward bias Q2 for the positive leg of the loop
DigitalOut Q3(PB_5);        // Solar Panel Voltage testing loop forward bias Q3 for the negetive leg of the loop back to the Solar
DigitalOut Q4(PB_4);        // Solar Panel Forward bias (Q4)transistor for the negetive leg
AnalogIn SolarVolt(PC_0);   // Solar Panel supply Voltage
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
 //////////////////////////////DECLARING HYDRO GENERATION TRANSISTOR'S OPARATIONAL PINS///////////////////////////////////////////
 
DigitalOut Q5(PB_13);       //Hydro Generator Forward bias Q5 transistor for the posistive leg
DigitalOut Q6(PB_14);       //Hydro Generator Voltage testing loop bias Q6 for the positive leg of the loop
DigitalOut Q7(PB_15);       //Hydro Generator Voltage testing loop bias Q7 for the negetive leg of the loop back to the hydro
DigitalOut Q8(PB_2);        //Hydro Generator Forward bias Q8 transistor nfor the egetive leg
AnalogIn HydroVolt(PC_1);   //Hydro Generator supply Voltage
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
//////////////////////////////DECLARING FAN TRANSISTOR'S PIN///////////////////////////////////////////

DigitalOut Q9(PC_6);        // Forward bias to keep the fan on
////////////////////////////////////////////////////////////////////////////////

///////////////////////////DECLARING WATER VALVE TRANSISTOR'S PIN//////////////

DigitalOut Q10(PC_8);       // Forward bias to keep the valve open
/////////////////////////////////////////////////////////////////////////////////

//////////////////////////////DECLARING BATTERY TRANSISTOR'S OPARATIONAL PINS/////////////////////////////////////////////////

DigitalOut Q11(PB_8);       // Battery Voltage testing loop bias Q11 for the positive leg of the loop
DigitalOut Q12(PC_9);       // Battery Voltage testing loop biasing Q12 for the negative leg of the loop down to nuetral of the load
AnalogIn BatVolt(PA_4);   // Battery Panel supply Voltage
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////DECLARING WATER METER TRANSISTOR'S OPARATIONAL PIN///////////////////////////////////

AnalogIn Met(PA_1);     // Water meter
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////DECLARING WATER SENSOR TRANSISTOR'S OPARATIONAL PIN///////////////////////////////
AnalogIn Sen(PA_0);     //Water Sensor
//////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////DECLARING WATER METER VARABLE//////////////////////////////////

double METER;          // Water Meter varable that posses a the current Kiloliter value

//////////////////////////////////////////////////////////////////////////////////////////


////////////IT'S A SUB PROGRAM THAT CLOSES THE WATER VALVE/////////////
void ClosedValve()
      { 
      Q10 = 0;
      }
////////////////////////////////////////////////////////////////////

///////////////////////IT'S A SUB PROGRAM THAT OPENS THE WATER VALVE////////////////////////
void OpenValve ()
                {
               Q10 = 1;
                }
////////////////////////////////////////////////////////////////////////

/////////////////IT'S A SUB PROGRAM THAT COMPARES THE WATER METER AND THE WATER SENSOR VALUES THAT ARE EQUAL///////////////
void Water_Valve ()
  {
     while (1)
            {
                if (Met.read_u16() != Sen.read_u16())
                {
                    ClosedValve();
                    wait (0.2);
                }
                else 
                {
                        OpenValve ();
                }
            }
   }
///////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////NORMAL OPARATIONS SUB PROGRAM WHICH BIAS THE TRANSISTORS//////////////////

void Normal()               // When every thing is running normal
{
    Q1 = 1;
    Q2 = 0;
    Q3 = 0;
    Q4 = 1;
    Q5 = 1;
    Q6 = 0;
    Q7 = 0;
    Q8 = 1;
    Q9 = 1;
  Water_Valve ();
    Q11 = 0;
    Q12 = 0;
}
////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////IT'S A SUB PROGRAM OF THE WATER SENSOR OPARATION////////////////////////////////////////////////////////////////
void Water_Sensor()
{

uint16_t senval;     //Declare variable to store the water analog value after conversion - 16-bit
uint32_t senval_sum; //Declare variable to store the water analog value sum in loop - 32-bit
double senkvolt;      //Declare 64-bit floating point data type to store water analog killovoltage value
   
    while(1)    
    {
    //read the 16-bit value from the analog pin,  The STM32F4-Trainer only supports 12-bit A/D (0 - 4095),
        senval = Sen.read_u16();     //but the read_u16 function converts it to a 16-bit value (0 - 65535)
        senval_sum = senval_sum + senval;      //Add every analog reading to the sum variable

    //calculate the voltage from the 16-bit value
         senkvolt = ((double)senval_sum* 0.00158) / 65535.0 * 3.3; //cast analogval to a double data type for formula to store result as double
        // 1 Volt = 1.58 litres then one kilolitres is 1580 acording to kyleconvert.com
        wait (0.2);
        }
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////IT'S A SUB PROGRAM OF THE WATER METER OPARATION///////////////////////////////////////////////////////////////
void Water_Readings()
{

uint16_t watval;     //Declare variable to store the water analog value after conversion - 16-bit
uint32_t watval_sum; //Declare variable to store the water analog value sum in loop - 32-bit
double watkvolt;      //Declare 64-bit floating point data type to store water analog killovoltage value
 
while(1)
    {
    //read the 16-bit value from the analog pin,  The STM32F4-Trainer only supports 12-bit A/D (0 - 4095),
        watval = Met.read_u16();     //but the read_u16 function converts it to a 16-bit value (0 - 65535)
        watval_sum = watval_sum + watval;      //Add every analog reading to the sum variable
   
    //calculate the voltage from the 16-bit value
         watkvolt = ((double)watval_sum * 0.00158) / 65535.0 * 3.3; //cast analogval to a double data type for formula to store result as double
        // 1 Volt = 1.58 litres then one kilolitres is 1580 acording to kyleconvert.com
        METER = watkvolt;    
        bt.printf(" %2.3f Volts \n", watkvolt); 
        wait (0.2);
        Normal ();
    }
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////IT'S A SUB PROGRAM THAT TEST THE SOLAR PANNEL'S VOLTAGE VALUE/////////////////////////////////////////////

void Test_Solar()       //The loop to test the Solar Panel's voltage
{
    Q1 = 0;
    Q2 = 1;
    Q3 = 1;
    Q4 = 0;
    Q5 = 1;
    Q6 = 0;
    Q7 = 0;
    Q8 = 1;
    Q9 = 1;
   
    Q11 = 0;
    Q12 = 0;
    
    uint16_t solval;     //Declare variable to store analog value after conversion - 16-bit
    double solvolt;      //Declare 64-bit floating point data type to store analog voltage value
    
        while (1)
        
        {
            //read the 16-bit value from the analog pin,  The STM32F4-Trainer only supports 12-bit A/D (0 - 4095),
            solval = SolarVolt.read_u16();     //but the read_u16 function converts it to a 16-bit value (0 - 65535)
          
            //calculate the voltage from the 16-bit value
            solvolt = ((double)solval*5.9613) / 65535.0 * 3.3; //cast analogval to a double data type for formula to store result as double
            //5.9613 convert the voltage value to equeal the supply
            bt.printf("%2.3f Volts \n", solvolt);  
            wait (5);
            Normal ();
        }
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////IT'S A SUB PROGRAM THAT TEST THE HYDRO GENERATOR'S VOLTAGE VALUE///////////////////////////////////////////////

void Test_Hydro()       // the loop to test the Hydro Generator's voltage
{
    Q1 = 1;
    Q2 = 0;
    Q3 = 0;
    Q4 = 1;
    Q5 = 0;
    Q6 = 1;
    Q7 = 1;
    Q8 = 0; 
    Q9 = 1;
    
    Q11 = 0;
    Q12 = 0;
    
    uint16_t hydval;     //Declare variable to store analog value after conversion - 16-bit
    double hydvolt;      //Declare 64-bit floating point data type to store analog voltage value
    
        while (1)
        
        {
            //read the 16-bit value from the analog pin,  The STM32F4-Trainer only supports 12-bit A/D (0 - 4095),
            hydval = HydroVolt.read_u16();     //but the read_u16 function converts it to a 16-bit value (0 - 65535)
          
            //calculate the voltage from the 16-bit value
            hydvolt = ((double)hydval * 5.9613) / 65535.0 * 3.3; //cast analogval to a double data type for formula to store result as double
            //5.9613 convert the voltage value to equeal the supply
            bt.printf("%2.3f Volts \n", hydvolt); 
            wait (5);
            Normal();
        }          
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////IT'S A SUB PROGRAM THAT TEST THE 12 VOLTS BATTERY'S VOLTAGE VALUE/////////////////////////////////////////////
void Test_Battery()         // The loop to test the battery's voltage
{
    Q1 = 0;
    Q2 = 0;
    Q3 = 0;
    Q4 = 0;
    Q5 = 0;
    Q6 = 0;
    Q7 = 0;
    Q8 = 0;
   
    Q9 = 0;
    Q11 = 1;
    Q12 = 1;
    
uint16_t battval;     //Declare variable to store analog value after conversion - 16-bit
double battvolt;      //Declare 64-bit floating point data type to store analog voltage value
while (1)
    {
    //read the 16-bit value from the analog pin,  The STM32F4-Trainer only supports 12-bit A/D (0 - 4095),
        battval = BatVolt.read_u16();     //but the read_u16 function converts it to a 16-bit value (0 - 65535)

    //calculate the voltage from the 16-bit value
         battvolt = ((double)battval * 5.9613) / 65535.0 * 3.3; //cast analogval to a double data type for formula to store result as double
        // 5.9613 convert the voltage value to equeal the supply
        bt.printf(" %2.3f Volts \n", battvolt); 
        wait (5);
        Normal ();
    } 
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////DECLARATION OF INCOME MESSAGE AS A CHARACTORS THAT COMES FROM THE PHONE APP//////////////////////////////////////

char btmsg[50];             //incoming message string
int btmsg_counter = 0;      //character position counter in the message string
int new_btmsg = 0;          //flag to indicate if a new complete message was received
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



////////////////////////////////IT'S A SUB PROGRAM THAT INTERRUPT THE ROUTINE WHEN A NEW CHARACTER ARRIVES/////////////////////////////////////////////
void btinterrupt() 
{    
    char c;                                     // declare the c as a charactor
    
    c = bt.getc();                              //read the incoming character
    if(c == '\n')                              //if it is the terminating character
       {
        if(btmsg[btmsg_counter - 1] == '\r')
            btmsg[btmsg_counter - 1] = '\0';
        else
            btmsg[btmsg_counter] = '\0';
        new_btmsg = 1;                          //enable the new message flag to indicate a COMPLETE message was received
        btmsg_counter = 0;                      //clear the message string
        }
    else 
        {
        btmsg[btmsg_counter] = c;               //add the character to the message string
        btmsg_counter++;                        //move to the next character in the string
        }   
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////THE MAIN PROGRAM WHERE IT WILL CALL ALL THE SUB PROGRAM//////////////////////////////////////////////
int main() {
    bt.attach(&btinterrupt);        //if a new character arrives, call the interrupt service routine
   
    while(1) { 
        Normal ();
        Water_Readings ();
        Water_Valve ();
        if(new_btmsg) {                                     //check if there is a new message
            if(strcmp(btmsg, "SolarON") == 0)              //message for SolarOn is ON
                Test_Solar();  
            else if(strcmp(btmsg, "HydrON") == 0)            //message for HydroOn is ON
               Test_Hydro() ;
            else if(strcmp(btmsg, "BatteryON") == 0)           //message for BatteryON is ON
                Test_Battery();
            else if(strcmp(btmsg, "WaterON") == 0)          //message for WaterOn is ON
              bt.printf("%2.3f Kl \n",METER);
            else if(strcmp(btmsg, "ValveOPEN") == 0)         //message for for ValveOpen is ON
               OpenValve();
            else if(strcmp(btmsg, "ValveClosed") == 0)         //message for for ValveClosed is ON
               ClosedValve();
            else
                bt.printf("Incorrect command\n");           //Reply incorrect command
                
            new_btmsg=0;                                    //clear message flag
        }
    }
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////