#include "mbed.h"
#include "mfcc.h"

#define SAMP_FREQ 16000
#define MFCC_DEC_BITS 2
#define FRAME_SHIFT_MS 40
#define FRAME_SHIFT ((int16_t)(SAMP_FREQ * 0.001 * FRAME_SHIFT_MS))
#define NUM_FRAMES 25
#define NUM_MFCC_COEFFS 10
#define MFCC_BUFFER_SIZE (NUM_FRAMES*NUM_MFCC_COEFFS)
#define FRAME_LEN_MS 40
#define FRAME_LEN ((int16_t)(SAMP_FREQ * 0.001 * FRAME_LEN_MS))

DigitalOut led(LED1);

int main()
{
    Serial pc (USBTX, USBRX);
    pc.baud(9600);
    
    MFCC* mfcc = new MFCC(NUM_MFCC_COEFFS, FRAME_LEN, MFCC_DEC_BITS);
    
    q7_t* mfcc_buffer = new q7_t[NUM_FRAMES*NUM_MFCC_COEFFS];
    
    int16_t* audio_data = new int16_t[FRAME_LEN*NUM_FRAMES];
      
    //int32_t mfcc_buffer_head = (num_frames-recording_win)*num_mfcc_features;
    int32_t mfcc_buffer_head = 0;
    
    for (uint16_t f = 0; f < FRAME_LEN * NUM_FRAMES; f++) {
        mfcc->mfcc_compute(audio_data,&mfcc_buffer[mfcc_buffer_head]);
        mfcc_buffer_head += NUM_MFCC_COEFFS;
    }

    while(1) {
        wait(1); // 1 second
        led = !led; // Toggle LED
        printf("%d.2", &mfcc_buffer);
    }
}
