#include "mbed.h"
//Adafruit MEMs SPW2430 microphone demo

BusOut myleds(LED1,LED2,LED3);
Serial pc (USBTX, USBRX);
bool countdown;

float received_buffer_1[22050];
float received_buffer_temp_1[22050];
float goes_to_mfcc_1[22050];
float received_buffer_2[22050];
float received_buffer_temp_2[22050];
float goes_to_mfcc_2[22050];
float threshold;
int counter;
float energy;
float energy_valued;
float bias;
float noise;
float mic_valued;
int mod;
float mic;

class microphone
{
    public :
        microphone(PinName pin);
        float read();
        operator float ();
    private :
        AnalogIn _pin;
};
microphone::microphone (PinName pin):
    _pin(pin)
{
}
float microphone::read()
{
    return _pin.read();
}
inline microphone::operator float ()
{
    return _pin.read();
}
 
microphone mymicrophone(A0);

int main(){
    pc.baud(9600);
    mod = 1;
    energy = 0;
    threshold = 0.03;//original is 0.03
    bias = 0.67/3.3;
    noise = 0.037;
    while(true){
        mic = (mymicrophone-bias);
        for(int t = 22048; t >= 0;t--){
            received_buffer_2[t+1]=received_buffer_2[t];        
        }
        received_buffer_2[0]=received_buffer_1[22049];
        for(int j = 22048; j >= 0;j--){
            received_buffer_1[j+1]=received_buffer_1[j];        
        }
        received_buffer_1[0] = mic;
        mod++;
        if((mod+400)%500 == 0 && mod >= 44100){
            for(int k = 16640; k <= 17640;k++){
                energy = energy + ((received_buffer_2[k]-noise)*(received_buffer_2[k]-noise));
            }
            if(energy >= threshold){
                //do mfcc here
                printf("\n\r");
                printf("mod = %d, energy = %f , threshold = %f", (mod-44100), energy, threshold);
                printf("\n\r");
                printf("doing mfcc");
                printf("\n\r");
                //for(int u = 0; u < 22050;u++){
                //    goes_to_mfcc_1[u]=received_buffer_1[u];        
                //}
                //for(int o = 0; o < 22050;o++){
                //    goes_to_mfcc_2[o]=received_buffer_2[o];        
                //}
                energy = 0;
            }
            else{
               energy = 0;
            }
        }
        wait(1.0/22050.0);      
    }
    //printf("\n\r");
    //printf("%f",energy);
    //printf("\n\r");
    //mic_mean = mic_mean / 44100.0f;
    //printf("%f",mic_mean);
    //printf("\n\r");


    //for(int k = 22049; k >= 0;k--){
    //    printf("%f",received_buffer_2[k]);      
    //}
    //for(int l = 22049; l >= 0;l--){
    //    printf("%f",received_buffer_1[l]);          
    //}
}
