
#define CHARGER_PRESET 32
//#define CHARGER_PRESET 16

#include "mbed.h"

AnalogIn cp_value(A1);      //A1 – PWM sense, analog read
AnalogIn pp_value(A2);      //A2 - PP, analog reads
PwmOut my_pwm(D5);          //pwm pin 5
DigitalOut lock(D7);
InterruptIn button(D8);

DigitalOut relay(D12);
DigitalOut contactor(D13);

Timer buttonTimer; //CC for reset button
Timeout buttonTimeout; //CC for reset button

DigitalOut green(D9);
DigitalOut red(D10);
DigitalOut blue(D11);

unsigned char control_pilot;
float pwmSet;

#define PILOT_12V   1
#define PILOT_9V    2
#define PILOT_6V    3
#define PILOT_NOK   4
#define PILOT_RESET 5

#define NUM_SAMPLES 2000 // size of sample series

#define SAMPLE_BLOCKS 1 //CC for reset button
#define RESET_SECONDS 5 //CC for reset button

bool resetDown = false;
bool resetCharger = false;

float CP_average=0;
float CP_previous_average=0;

unsigned char cableType;

void timedOut() {
    resetCharger = true;
    printf("Button pressed for more than 3 sec ! Charger reset !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! \r\n");
}

void resetPress() {
    printf("Reset button pressed ... starting timer \r\n");
    buttonTimer.stop();
    buttonTimer.reset();
    buttonTimer.start();
    resetDown = true;   
    buttonTimeout.attach(&timedOut, RESET_SECONDS);   
}   

void resetRelease() {
    printf("Reset button released \r\n");
    int elapsedSeconds = buttonTimer.read();
    buttonTimer.stop();
    buttonTimer.reset();
    if (elapsedSeconds > 3) {
        resetCharger = true;
        printf("Button was pressed for more than 3 sec !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! \r\n");
    }
    else{
    printf("If we're getting here then we've released the button before 3 seconds were up.\r\n");
    }
    printf("We will detach the timeout an setup for the next time.\r\n");
    printf("%u \r\n", elapsedSeconds);
    buttonTimeout.detach();
}


int main() {     

    button.fall(&resetPress);
    button.rise(&resetRelease);
    
    while(1){
               
    float PP_value = pp_value.read();
    PP_value = PP_value * 3300;
   
    
    
         
    for (int i = 0; i < NUM_SAMPLES ; i++){
        float CP_sample_value = cp_value.read_u16();
        CP_sample_value = (float) 3300 / 65535 * (float) CP_sample_value;  // convert sample to voltage
        CP_average = ((CP_sample_value + (i * CP_previous_average)) / (i+1));
        CP_previous_average = CP_average; 
    }
    printf("CP Average Value   = %.f \n\r", CP_average);
    printf("PP Value           = %.0f mV\n\r",PP_value);
    printf("\n\r");

if(PP_value>3200){  //NO CABLE IN

    if ((2750 > CP_average) &&  (CP_average > 2650) || (800 > CP_average) && (CP_average > 700)){         
            control_pilot = PILOT_12V;    // Pilot at 12V 
    }
    if (CP_average < 100){  // first reading ˜2702 & ˜755 after        
            control_pilot = PILOT_12V;    // Pilot at 12V 
            resetCharger = false;
    }
}
        
if((300 > PP_value) && (PP_value >200)){        //16AMP CABLE IN
    pwmSet=0.734;
    if(((CP_average > 1900)&&(2100 > CP_average))||((CP_average > 550)&&(650 > CP_average))){
        control_pilot = PILOT_9V;
        printf("16amp@ 9 V \n\r");
    }
    if((CP_average > 400)&&(500 > CP_average)){
        control_pilot = PILOT_6V;
        printf("16amp@ 6 V \n\r");
    }
    if((resetCharger == true)||((CP_average > 700)&&(800 > CP_average))){
        control_pilot = PILOT_RESET;
        printf("reset \n\r");
    }
}
        
if(100 > PP_value){//32AMP CABLE IN
    pwmSet=0.468;
    if(((CP_average > 1900)&&(2100 > CP_average))||((CP_average > 1070)&&(1170 > CP_average))){
        control_pilot = PILOT_9V;
        printf("32amp@ 9 V \n\r");
    }
    if((CP_average > 730)&&(830 > CP_average)){
        control_pilot = PILOT_6V;
        printf("32amp@ 6 V \n\r");
    }
    if(resetCharger == true){
        control_pilot = PILOT_RESET;
        printf("reset \n\r");
    }
}

 //------------------------------------------- STATE ASSIGNED ------------------------------------------------//
       
switch(control_pilot) {
        case PILOT_12V:
            printf("Charger in STATE A\r\n");
            printf("PILOT_12V - Pilot at 12 V \n\r");
            my_pwm = 0;
            contactor =0;
            lock=0;
            red = 0;
            green = 0;
            blue = 1;
            break;
  
        case PILOT_9V:
            contactor =0;
            lock=1;
            my_pwm.period_ms(1);
            my_pwm.pulsewidth_ms(1);
            my_pwm.write(pwmSet);
            printf("Charger in STATE b\r\n");
            printf("PILOT_9V - Pilot at 9 V \n\r");
            red = 1;
            green = 1;
            blue = 0;
            break;
                
        case PILOT_6V:
            contactor =1;
            relay=1;
            lock=1;
            my_pwm.period_ms(1);
            my_pwm.pulsewidth_ms(1);
            my_pwm.write(pwmSet);
            printf("Charger in STATE c\r\n");
            printf("PILOT_6V - Pilot at 6 V \n\r");
            red = 0;
            green = 1;
            blue = 0;
            break;
                   
        case PILOT_NOK:
            printf("Error");
            printf("PILOT_NOK - Pilot ERROR \n\r");
            lock=0;
            red = 1;
            green = 0;
            blue = 0;
            break;
            
        case PILOT_RESET:
            printf("RESET IMPLEMENTED \n\r");
            printf("PILOT_RESET - Pilot at -12V \n\r");
            my_pwm.period_ms(1);
            my_pwm.pulsewidth_ms(1);
            my_pwm.write(1);
            contactor =0;
            relay=0;
            lock=0;
            red = 1;
            green = 0;
            blue = 0;
            wait(0.5); // 200 ms
            red = 0; // LED is OFF
            wait(0.2); // 1 sec
            break;
           
        }//end switch
      
wait(2);      
       
  } //end while(1)
  
} //end main  
    


