// Bouncing Betty Halloween Effect
// By: Michael Fischler
// Residence Hall Association 2011-2012

#include "mbed.h"                                   // Built for Mbed NXP LPC1768 Microprocessor 
#include "PowerControl/PowerControl.h"              // for power mgmt
#include "PowerControl/EthernetPowerControl.h"      // for power mgmt
#include "wave_player.h"                            // for speakers
#define USR_POWERDOWN    (0x104)
int semihost_powerdown() {
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);
}

DigitalOut latch1(p15);  // Latch on RGB LED 1
DigitalOut enable1(p16); // Enable on RGB LED 1
SPI spi1(p11, p12, p13); // SPI for RGB LED 1

DigitalOut latch2(p8);  // Latch on RGB LED 2
DigitalOut enable2(p9); // Enable on RGB LED 2
SPI spi2(p5, p6, p7);   // SPI for RGB LED 2

AnalogOut DACout(p18);
wave_player waver(&DACout);

AnalogIn sonar(p20);        // Sonar Input
DigitalIn pushbutton(p24);  // Pushbutton Input

DigitalOut wdtLED(LED4);//WatchDog Indicator

LocalFileSystem local("local");

float distance;         // distance for sonar analog input
float j = 0;            // Alternate Variable for Blue/Green
bool j_increase = 1;    // Direction of Blue/Green Alternating

class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};

Watchdog wdt;

void RGB_LED(int red1, int green1, int blue1, int red2, int green2, int blue2) {    //Use SPI hardware to write color values to LED driver chip
    unsigned int low_color1=0;
    unsigned int high_color1=0;
    unsigned int low_color2=0;
    unsigned int high_color2=0;
    high_color1=(blue1<<4)|((red1&0x3C0)>>6);
    low_color1=(((red1&0x3F)<<10)|(green1));
    high_color2=(blue2<<4)|((red2&0x3C0)>>6);
    low_color2=(((red2&0x3F)<<10)|(green2));
    spi1.write(high_color1);
    spi1.write(low_color1);
    spi2.write(high_color2);
    spi2.write(low_color2);
    latch1=1;
    latch2=1;
    wait(0.1);
    latch1=0;
    latch2=0;
}

void RGB_LED1(int red1, int green1, int blue1) {    //Use SPI hardware to write color values to LED driver chip
    unsigned int low_color1=0;
    unsigned int high_color1=0;
    high_color1=(blue1<<4)|((red1&0x3C0)>>6);
    low_color1=(((red1&0x3F)<<10)|(green1));
    spi1.write(high_color1);
    spi1.write(low_color1);
    latch1=1;
    wait(0.1);
    latch1=0;
}

void RGB_LED2(int red2, int green2, int blue2) {    //Use SPI hardware to write color values to LED driver chip
    unsigned int low_color2=0;
    unsigned int high_color2=0;
    high_color2=(blue2<<4)|((red2&0x3C0)>>6);
    low_color2=(((red2&0x3F)<<10)|(green2));
    spi2.write(high_color2);
    spi2.write(low_color2);
    latch2=1;
    wait(0.1);
    latch2=0;
}

int main() {

    int result = 0;
    if ((LPC_WDT->WDMOD >> 2) & 1)
        wdtLED = 1;
    else wdtLED = 0;

    // 30 second timeout on watchdog timer hardware
    wdt.kick(10.0);

    //Power Management
    PHY_PowerDown();                      // Power Down Ethernet
    result = semihost_powerdown();        // Power Down USB Interface Chip (blue status LED)



    pushbutton.mode(PullUp);
    spi1.format(16,0);
    spi1.frequency(500000);
    spi2.format(16,0);
    spi2.frequency(500000);
    enable1=0;
    latch1=0;
    enable2=0;
    latch2=0;
    wait(2);

    RGB_LED(50,50,50,50,50,50);

    wait(5);

    while (1) {
        //Analog Input
        distance = 11.261/sonar; //0.4 (80cm) to 0.98 (6cm)

        if ((distance < 40)||(pushbutton == 0)) {
            FILE *wave_file;                               // create pointer
            wave_file = fopen("/local/scream.wav","r");    // Open wave file
            RGB_LED(50,0,0,50,0,0);                        // LEDS to Red
            waver.play(wave_file);                         // Play Sound
            fclose(wave_file);                             // Close File
        } else {
            if (j_increase) {
                j = j + 2;
                if (j > 48) {
                    j_increase = 0;
                }
            } else {
                j=j - 2;
                if (j < 2) {
                    j_increase = 1;
                }
            }
            RGB_LED(0,50-j,j,0,50-j,j);                    // Fade between blue and green

        }
        wdt.kick();
    }

}
