#include "mbed.h"
#include "LED.h"        // LEDs framework for blinking ;)
#include "IMU_10DOF.h"  // Complete IMU class for 10DOF-Board (L3G4200D, ADXL345, HMC5883, BMP085)
#include "PC.h"         // Serial Port via USB by Roland Elmiger for debugging with Terminal (driver needed: https://mbed.org/media/downloads/drivers/mbedWinSerial_16466.exe)

#define RATE            0.002                               // speed of the interrupt for Sensors and PID

LED         LEDs;
PC          pc(USBTX, USBRX, 921600);   // USB
IMU_10DOF   IMU(p28, p27);

Ticker Dutycycler;                      // timecontrolled interrupt for exact timed control loop

void dutycycle() { // method which is called by the Ticker Dutycycler every RATE seconds
    IMU.readAngles();
}

void executer() {
    pc.putc(pc.getc());
    LEDs.tilt(2);
}

int main() {
    Dutycycler.attach(&dutycycle, RATE);     // start to process all RATE seconds
    pc.attach(&executer);
    while(1) {
        #warning The current version has some hardcoded calibration values, change them in order to get high precision, to find them look out for_ warnings (sorry for_ that hope to get time to develop autocalibration)
        // just putting out the angle on console
        IMU.readAltitude(); // reading altitude takes much more time than the angles -> don't do this in your fast loop
        pc.printf("%.1f,%.1f,%.1f,%.1f'C,%.1fhPa,%.1fmaS,%.5fs,%.5fs\r\n", IMU.angle[0], IMU.angle[1], IMU.angle[2], IMU.temperature, IMU.pressure, IMU.altitude, IMU.dt, IMU.dt_sensors); // Output for Python
        
        wait(0.01); // this is to avoid buffer overflow in the Computers UART-Controller

        LEDs.tilt(1);
    }
}