#include "mbed.h"
// the MAX7219 address map (datasheet table 2)
#define MAX7219_DECODE_REG      (0x09)
#define MAX7219_INTENSITY_REG   (0x0A)
#define MAX7219_SCANLIMIT_REG   (0x0B)
#define MAX7219_SHUTDOWN_REG    (0X0C)
#define MAX7219_DISPLAYTEST_REG (0x0F)
#define MAX7219_DIGIT_REG(pos)  ((pos) + 1)

// shutdown mode (datasheet table 3)
#define MAX7219_OFF             (0x0)
#define MAX7219_ON              (0x1)

// digit pattern for a 7-segment display. datasheet table 5
const char digit_pattern[16] =
{
  0x7E,  // 0
  0x30,  // 1
  0x6D,  // 2
  0x79,  // 3
  0x33,  // 4
  0x5B,  // 5
  0x5F,  // 6
  0x70,  // 7
  0x7F,  // 8
  0x7B,  // 9
  0x77,  // A
  0x1F,  // b
  0x4E,  // C
  0x3D,  // d
  0x4F,  // E
  0x47   // F
};

const float step=0.001;  //step for push button pwm will increase or decrease by this value when pushing

const float MIN =0; // PWM rate bounds
const float MAX =1;
const int PWM_period = 10; // pwm period in ms

Serial pc(SERIAL_TX,SERIAL_RX);
//DigitalOut myled(LED1);
DigitalIn set_plus(PB_5);  //input for increasing pwm cycle
DigitalIn set_less(PB_4); //input for decreasing pwm cycle
DigitalIn safe_or_button(PB_10); //input for setting pot or button as master
// DigitalIn pause(a definir); //input for setting pause and returning to last value, this to avoid waiting to go up to last value
long n,u,d,c,m, dm,ddm,cm,mm;  // pour l'afficheur 
void fermeture(); // relais 1 & 3 fermés
void ouverture(); // relais 2 & 4 fermés
void neutre();    // tout relais ouverts
PwmOut      my_pwm(PF_9); 
float pot_value = 0;
int pot_value_display = 0;
int pot_pause = 0; // buffer value when setting in pause
//SPI spimax(D11, D12, D13); DigitalOut CS(D9);  // pins for F411RE
//mosi , miso, clk
SPI spimax(PA_7, PA_6, PA_5); DigitalOut CS(D8); //pins for F767ZI

void max7219(char reg,char dta) { CS = 0; spimax.write(reg); spimax.write(dta); CS = 1; } // function to write to max7219 7 seg display

float bound(float value)  // bound value when push buttons are activated too long
{
    if(value < MIN)
        return MIN;
    else if(value > MAX)
        return MAX;
    else
        return value;
}

void init_max7219()
{
  // Turn on the display
  max7219(MAX7219_SHUTDOWN_REG, MAX7219_ON);
   // enable test mode. datasheet table 10
  max7219(MAX7219_DISPLAYTEST_REG, MAX7219_ON);
  wait(1);
  // disable test mode. datasheet table 10
  max7219(MAX7219_DISPLAYTEST_REG, MAX7219_OFF);
  // set medium intensity. datasheet table 7
  max7219(MAX7219_INTENSITY_REG, 0x5);
  // turn off display. datasheet table 3
 // max7219(MAX7219_SHUTDOWN_REG, MAX7219_OFF);
  // drive 8 digits. datasheet table 8
  max7219(MAX7219_SCANLIMIT_REG, 7);
  // no decode mode for all positions. datasheet table 4
  max7219(MAX7219_DECODE_REG, 0x00);
  for(int i = 1; i < 9; i++)  // delete all chars
                {
                max7219(i,0x01);
                }
}

int main() { 
      
set_plus.mode(PullDown);
set_less.mode(PullDown);
safe_or_button.mode(PullDown);
init_max7219();
    pc.printf("end init");
         max7219(1,digit_pattern[0]);
         max7219(2,digit_pattern[0]);
         max7219(3,digit_pattern[0]);
         
          max7219(8,digit_pattern[5]); // writing "safe"
          max7219(7,digit_pattern[10]);
          max7219(6,digit_pattern[15]);
          max7219(5,digit_pattern[14]);
        // Set PWM
 my_pwm.period_ms(PWM_period);

while(1) { 
 
    if (safe_or_button == 0) {
      //  pot_value = pot.read();
         pot_value = 0;
        my_pwm.write(pot_value);   // sets duty cycle directly through reading normalised pot value
    //    pc.printf("safe_or_button =0 setting PWM to 0%");
         max7219(1,digit_pattern[0]);
         max7219(2,digit_pattern[0]);
         max7219(3,digit_pattern[0]);
         
          max7219(8,digit_pattern[5]); // writing "safe"
          max7219(7,digit_pattern[10]);
          max7219(6,digit_pattern[15]);
          max7219(5,digit_pattern[14]);
        }
        else 
            for(int i = 4; i < 9; i++)  // delete "safe" writing
                {
                max7219(i,0x00);
                }
    //        if pause = 1 break
            if (set_plus == 1) {
            pot_value = bound(pot_value + step); 
      //      pc.printf("safe_or_button value ==1, set_plus =1");
            pc.printf(" pot_value :  ");
            pc.printf("%f\n",pot_value);
            
            my_pwm.write(pot_value);   // sets duty cycle directly through reading normalised pot value
            pot_value_display = int (1000 * pot_value);
            c = pot_value_display/100; 
            d = pot_value_display/10 - 10*c; 
            u = pot_value_display - 100*c - 10*d;
            max7219(1,digit_pattern[u]);
            max7219(2,digit_pattern[d]);
            max7219(3,digit_pattern[c]);
            wait_ms(40); // to avoid taking more than one or 2 button press
            }
            else if (set_less == 1) {
                pot_value = bound(pot_value - step);
          //      pc.printf("safe_or_button value ==1, set_less =1"); // button state display on serial monitor
                pc.printf(" pot_value :  ");
                pc.printf("%f\n",pot_value);
                my_pwm.write(pot_value);   // sets duty cycle directly through reading normalised pot value
                for(int i = 4; i < 7; i++)  // delete "safe" writing
                {
                max7219(i,0x00);
                }
                pot_value_display = int (1000 * pot_value);
                c = pot_value_display/100; 
                d = pot_value_display/10 - 10*c; 
                u = pot_value_display - 100*c - 10*d;
                max7219(1,digit_pattern[u]);
                max7219(2,digit_pattern[d]);
                max7219(3,digit_pattern[c]);
                wait_ms(40); // to avoid taking more than one or 2 button press
            }
       //     pot_pause = pot_value  // pas bon
        }


}


 