/* cycling using relay command through discrete
2017 19 10 by mael reymond
function :
display state on led onboard
command 2 relays (1 per direction)
send on serial monitor number of cycles since power on*/

#include "mbed.h"
Serial pc(SERIAL_TX,SERIAL_RX);
DigitalOut myled(LED1);
DigitalInOut relais_1(PB_5); // voir montage pont en H http://eskimon.fr/285-arduino-601-le-moteur-courant-continu
DigitalInOut relais_2(PB_8);
DigitalInOut relais_3(PC_7);
DigitalInOut relais_4(PA_9);
AnalogIn status(PC_5);

SPI spimax(D11, D12, D13); DigitalOut CS(D9); // for MAX7219 7 segment display
// the MAX7219 address map (datasheet table 2)
#define MAX7219_DECODE_REG      (0x09)
#define MAX7219_INTENSITY_REG   (0x0A)
#define MAX7219_SCANLIMIT_REG   (0x0B)
#define MAX7219_SHUTDOWN_REG    (0X0C)
#define MAX7219_DISPLAYTEST_REG (0x0F)
#define MAX7219_DIGIT_REG(pos)  ((pos) + 1)

// shutdown mode (datasheet table 3)
#define MAX7219_OFF             (0x0)
#define MAX7219_ON              (0x1)

// digit pattern for a 7-segment display. datasheet table 5
const char digit_pattern[16] =
{
  0x7E,  // 0
  0x30,  // 1
  0x6D,  // 2
  0x79,  // 3
  0x33,  // 4
  0x5B,  // 5
  0x5F,  // 6
  0x70,  // 7
  0x7F,  // 8
  0x7B,  // 9
  0x77,  // A
  0x1F,  // b
  0x4E,  // C
  0x3D,  // d
  0x4F,  // E
  0x47   // F
};


int counter = 0;
int duree_fermeture = 3; // par defaut 4 secondes
int duree_ouverture = 3; // par defaut 4 secondes
int duree_neutre = 0.2; // par defaut 200 ms 
long n,u,d,c,m, dm,ddm,cm,mm;  // pour l'afficheur  
void fermeture(); // relais 1 & 3 fermés
void ouverture(); // relais 2 & 4 fermés
void neutre();    // tout relais ouverts
void max7219(char reg,char dta) { CS = 0; spimax.write(reg); spimax.write(dta); CS = 1; }


void init_max7219()
{
  // Turn on the display
  max7219(MAX7219_SHUTDOWN_REG, MAX7219_ON);
   // enable test mode. datasheet table 10
  max7219(MAX7219_DISPLAYTEST_REG, MAX7219_ON);
  wait(6);
  // disable test mode. datasheet table 10
  max7219(MAX7219_DISPLAYTEST_REG, MAX7219_OFF);
  // set medium intensity. datasheet table 7
  max7219(MAX7219_INTENSITY_REG, 0x8);
  // turn off display. datasheet table 3
 // max7219(MAX7219_SHUTDOWN_REG, MAX7219_OFF);
  // drive 8 digits. datasheet table 8
  max7219(MAX7219_SCANLIMIT_REG, 7);
  // no decode mode for all positions. datasheet table 4
  max7219(MAX7219_DECODE_REG, 0x00);
}
int main() {   

init_max7219();
/*max7219(1,0x02);wait(2);

max7219(3,0x06);wait(2);

max7219(5,0x70);wait(2);
max7219(7,digit_pattern[2]);wait(2);
max7219(2,digit_pattern[6]);wait(2);

*/
   /* relais_1.mode(PullDown);
    relais_2.mode(PullDown);
    relais_3.mode(PullDown);
    relais_4.mode(PullDown);    */
     
max7219(1,0x00);wait(2);
    while(1) {     

      /*  pc.printf("status :  %3.3f%%\n", status.read()); // counter display on serial monitor
               pc.printf("status normalised:  0x%04X \n", status.read_u16()); // counter display on serial monitor
        bool etat =0;
        if (status.read()>0.8) { etat =1 ;}else etat = 0;
         pc.printf("etat : %d\n", etat ); // counter display on serial monitor
        myled = 1; // LED is ON         
        /*
        neutre();
        ouverture();
        neutre();
        fermeture();
       counter++; //counter increment
  //      pc.printf("counter : %d\n", counter ); // counter display on serial monitor
    
        // display cycle number
         dm = counter/10000000;
         mm = counter/1000000 -10*dm;
         cm = counter/100000 -100*dm -10*mm;
         ddm = counter/10000 -1000*dm -100*mm - 10 *cm;
         m = counter/1000 -10000*dm -1000*mm - 100 *cm -10*ddm;
         c = counter/100 -100000*dm -10000*mm - 1000 *cm -100*ddm - 10*m;
         d = counter/10 -1000000*dm -100000*mm - 10000 *cm -1000*ddm - 100*m - 10*c;
         u = counter - 10000000*dm -1000000*mm - 100000 *cm -10000*ddm -1000*m - 100*c - 10*d;
         
    //     dm = counter/10000000;
      //   mm = counter/1000000 -10*dm;
      //   cm = counter/100000 -100*dm -10*mm;
       //  ddm = counter/10000 -1000*dm -100*mm - 10 *cm;
   /*      m = counter/1000;
         c = counter/100 - 10*m;
         d = counter/10 - 100*m - 10*c;
         u = counter -1000*m - 100*c - 10*d;
     */    
         if (u == 9) { 
         pc.printf("counter : %d", counter); // counter display on serial monitor
         pc.printf(" m : %d", m);
         pc.printf("c : %d", c);
         pc.printf("d : %d", d);
         pc.printf("u : %d", u);
         }
     //    wait_ms(10);
         
         max7219(1,digit_pattern[u]);
         max7219(2,digit_pattern[d]);
         max7219(3,digit_pattern[c]);
         max7219(4,digit_pattern[m]);
         max7219(5,digit_pattern[ddm]);
         max7219(6,digit_pattern[cm]);
         max7219(7,digit_pattern[mm]);
         max7219(8,digit_pattern[dm]);   
     }
}


void ouverture() 
{

// relais 2 & 3 fermés
         
    relais_2.input();
    relais_3.input();
    
        relais_2.output();
        relais_2= !relais_2;
        relais_3.output();
        relais_3= !relais_3;

    myled = 0; // LED is OFF
    wait(duree_ouverture);
    
    
}

void fermeture() 
{
  
  // relais 1 & 3 fermés
    myled = 1; // LED is ON
        relais_1.output();
        relais_1= !relais_1;
        relais_4.output();
        relais_4= !relais_4;
    wait(duree_fermeture);
    
}


void neutre() 
{

// setting every relay pins as output HIGH, since relays command is a ground
    relais_1.output();
    relais_2.output();
    relais_3.output();
    relais_4.output();
    relais_1= 1;
    relais_2= 1;
    relais_3= 1;
    relais_4= 1;
    
    myled = 1; // LED is ON
    wait(duree_neutre);
    
}


