#include "mbed.h"

InterruptIn userButton(PC_13);
DigitalOut  userLed(PA_5);

DigitalOut Vcc(PA_0);
AnalogIn aInn(PA_1);
DigitalOut Gnd(PA_4);

PwmOut      servoMotor(PA_7);
DigitalOut  direction(PA_6);

void pressed()
{
    userLed=!userLed;     // Toogle user led
    direction=!direction; // Change motor direction
    
}

int main()
{
    userButton.fall(&pressed);
    servoMotor.period(.01);

    Vcc=1;
    Gnd=0;

    while(1) {
        
        if(direction)
        {
        servoMotor=(1-aInn.read());
        }
        else
        {
        servoMotor=(aInn.read());
        }
    }

}
