/**
 * @file main.c
 * @brief ILI9163/DL144128TF 128x128 TFT LCD Test code
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Jun Morita (iccraft)
 *
 * @copyright   Copyright (C) 2012 Simon Inns
 * @author Simon Inns <simon.inns@gmail.com>
 */

#include "mbed.h"
#include "ili9163lcd.h"
//#include "stdint.h"

ILI9163 TFT(D2,D3,D5,D6);

int main()
{TFT.lcdReset();
TFT.lcdInitialise(LCD_ORIENTATION0);
    TFT.lcdClearDisplay(White);

//TFT.lcdReset();
/*
TFT.lcdInitialise(LCD_ORIENTATION0);
 TFT.lcdPutS("SENSESEMI", TFT.lcdTextX(1), TFT.lcdTextY(2),Purple ,Black);
TFT.lcdClearDisplay(Purple);
TFT.lcdClearDisplay(DarkGrey);
TFT.lcdClearDisplay(Red  );
TFT.lcdClearDisplay(Blue );
TFT.lcdClearDisplay( Orange);
TFT.lcdClearDisplay(LightBlue );
TFT.lcdClearDisplay(Black);

TFT.lcdReset();
//TFT.lcdCircle(64,64,50,Black );
//TFT.lcdLine(0, 0, 160, 160, 'Yellow');


}*/


   
    while(1){
   // TFT.lcdClearDisplay(White);
    TFT.set_font((unsigned char*)font24x23); 
    
  TFT.lcdPutS("SENSESEMI", TFT.lcdTextX(1), TFT.lcdTextY(2),White ,Black);
 wait_ms(500);


 
const uint8_t NXP_banner_bmp[6150] = {
0x00,0x10, //First 6 bytes are the header
0x20,0x00, //They contain the Width and Height
0x60,0x00, //Width = 96(0x60)Pixels, Height = 32(0x20)Pixels
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE4,0xFD,0xC2,0xFD,
0xC2,0xFD,0xC2,0xFD,0xC2,0xFD,0xC2,0xFD,0xC2,0xFD,0x06,0xFE,0xBC,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x28,0xC5,0x68,0x9C,0x68,0x9C,0x68,0x9C,0x68,0x9C,0x68,0x9C,
0x68,0x9C,0x11,0x95,0xBB,0x85,0x7E,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3E,0xD7,0xBB,0x85,0x2C,0x7D,0xE8,0x7C,
0xE8,0x7C,0xE8,0x7C,0xE8,0x7C,0xE8,0x7C,0xE8,0x7C,0xE4,0xAD,0xA2,0xCE,0xA2,0xCE,
0xA2,0xCE,0xA2,0xCE,0xA2,0xCE,0xA2,0xCE,0xA2,0xCE,0xA2,0xCE,0xA2,0xCE,0xA2,0xCE,
0xA2,0xCE,0xA3,0xCE,0xC6,0xD6,0x0B,0xDF,0x74,0xEF,0xDC,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x27,0xFE,0xDE,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC3,0xF5,0x46,0xA4,0x26,0x94,0x26,0x94,0x26,0x94,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0xFC,0x95,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xF7,0xDB,0x8D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0xC6,0x74,0xC6,0x74,0xC6,0x74,0x05,0x85,0x80,0xC6,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0xA2,0xCE,0x52,0xE7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x6A,0xFE,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0x22,0xDD,0x26,0x94,0x26,0x94,0x26,0x94,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0xDD,0xBE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7D,0xAE,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0xC6,0x74,0xC6,0x74,0xA6,0x74,0x21,0xB6,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x50,0xE7,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xCF,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,0x85,0xAC,0x26,0x94,0x26,0x94,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0xBB,0x85,0xBF,0xEF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x7E,0xDF,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0xC6,0x74,0xC6,0x74,0x64,0x95,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0xBA,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0x13,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,0x61,0xED,0x26,0x9C,0x26,0x94,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x5C,0xA6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xDF,0xF7,0xFC,0x8D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0xC6,0x74,0xE5,0x7C,0x60,0xC6,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x0B,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA1,0xFD,0x35,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,0xA0,0xFD,0xE3,0xC4,0x26,0x94,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x1E,0xCF,0xFF,0xFF,
0xFF,0xFF,0xBD,0xBE,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0xC6,0x74,0x02,0xAE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0xA2,0xCE,0xA2,0xCE,
0xA2,0xCE,0xA2,0xCE,0xA2,0xCE,0xA2,0xCE,0xA2,0xCE,0xA2,0xCE,0xA2,0xCE,0xA2,0xCE,
0x81,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0xA3,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xC1,0xFD,0x78,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x46,0xA4,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xBB,0x85,0xDF,0xF7,
0x9F,0xE7,0xBB,0x85,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0x44,0x8D,0x80,0xCE,0x80,0xCE,0x80,0xCE,0xC6,0xD6,0xDD,0xFF,0xFD,0xFF,
0xFD,0xFF,0xFD,0xFF,0xFD,0xFF,0xFD,0xFF,0xFD,0xFF,0xFD,0xFF,0xFD,0xFF,0xFD,0xFF,
0xBB,0xF7,0xE9,0xDE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x81,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xE3,0xFD,0xBC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x41,0xE5,0x07,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x7C,0xAE,
0x3C,0x9E,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0x41,0xBE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0xC7,0xD6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xDD,0xFF,0xA2,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x81,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x27,0xFE,0xDD,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA4,0xBC,
0x06,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,
0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0x83,0x9D,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0xC7,0xD6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFE,0xFF,0xC5,0xD6,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x81,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xC2,0xFD,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x49,0xFE,0xDE,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x80,0xF5,
0x26,0x9C,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,
0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xE5,0x7C,
0x80,0xC6,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0xC7,0xD6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFE,0xFF,0xC5,0xD6,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x81,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0x8C,0xFE,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x6B,0xFE,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0x02,0xD5,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,
0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0x21,0xB6,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0xC7,0xD6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFE,0xFF,0xA3,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x81,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0xDE,0xFF,0x27,0xFE,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xD0,0xFE,
0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0x0F,0x9D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,
0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x88,0x95,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0xC7,0xD6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xB8,0xF7,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x81,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0xFF,0xFF,0xBC,0xFF,
0xE4,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0x34,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0x2E,0xA5,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,
0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xC8,0x9D,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0xC6,0xD6,0xBA,0xF7,0xBA,0xF7,
0xBA,0xF7,0xBA,0xF7,0xBA,0xF7,0xBA,0xF7,0xBA,0xF7,0xBA,0xF7,0xBA,0xF7,0xBA,0xF7,
0x95,0xEF,0xA4,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x81,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0xFF,0xFF,0xFF,0xFF,
0x9A,0xFF,0xC3,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xC1,0xFD,0x57,0xFF,0xC3,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0x02,0xDD,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,
0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0x21,0xB6,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0xA3,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x79,0xFF,0xC1,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0xC2,0xFD,0xA1,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x80,0xF5,
0x46,0x9C,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,
0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0x05,0x85,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x0C,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x35,0xFF,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xC3,0xC4,
0x06,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,
0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xA6,0x74,
0xA3,0xA5,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0xBA,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF1,0xFE,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x61,0xED,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x3C,0x9E,
0x1C,0x96,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xE6,0x7C,0x60,0xC6,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x2F,0xE7,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAD,0xFE,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x65,0xA4,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xBB,0x85,0xBF,0xF7,
0x7E,0xE7,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0x44,0x8D,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,
0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0x80,0xCE,0xA2,0xCE,0x51,0xE7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDE,0xFF,0x49,0xFE,0xA0,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xE3,0xCC,0x26,0x94,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x1E,0xCF,0xFF,0xFF,
0xFF,0xFF,0xBD,0xB6,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0xC6,0x74,0x01,0xB6,0x80,0xCE,0x80,0xCE,0x81,0xCE,0xE7,0xD6,0xE7,0xD6,
0xE7,0xD6,0xE7,0xD6,0xE7,0xD6,0xE7,0xD6,0xE7,0xD6,0xE7,0xD6,0xE7,0xD6,0xE7,0xD6,
0xE7,0xD6,0xE7,0xD6,0xE8,0xD6,0x0B,0xDF,0x51,0xE7,0xDC,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDE,0xFF,0x05,0xFE,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x80,0xF5,0x26,0x9C,0x26,0x94,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0x1C,0x9E,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xDF,0xF7,0xDB,0x85,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0xC6,0x74,0xE5,0x7C,0x80,0xCE,0x80,0xCE,0xC7,0xD6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBC,0xFF,0xE4,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x84,0xB4,0x26,0x94,0x26,0x94,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0xBB,0x85,0x9E,0xE7,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x3E,0xD7,0x9B,0x7D,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0xC6,0x74,0xA6,0x74,0x83,0x9D,0x80,0xCE,0xC7,0xD6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9A,0xFF,
0xC2,0xFD,0xA0,0xFD,0xA0,0xFD,0x22,0xDD,0x26,0x94,0x26,0x94,0x26,0x94,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0x9B,0x7D,0xBD,0xBE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x5C,0xAE,0x9B,0x7D,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0xC6,0x74,0xC6,0x74,0xC6,0x74,0x21,0xBE,0xC7,0xD6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0xFD,0xA0,0xFD,
0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0xA0,0xFD,0x8D,0xFE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x57,0xFF,0xA1,0xFD,0xA0,0xFD,0x46,0xA4,0x26,0x94,0x26,0x94,0x26,0x94,0x26,0x94,
0x26,0x94,0xD0,0x8C,0x9B,0x7D,0xFC,0x8D,0xDF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,0xF7,0xBB,0x85,0x9B,0x7D,0xEA,0x74,0xC6,0x74,
0xC6,0x74,0xC6,0x74,0xC6,0x74,0xC6,0x74,0x25,0x85,0xC7,0xD6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE3,0xFD,0xA1,0xFD,
0xA1,0xFD,0xA1,0xFD,0xA1,0xFD,0xA1,0xFD,0xA0,0xFD,0xAD,0xFE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x13,0xFF,0xE4,0xC4,0x27,0x94,0x27,0x94,0x27,0x94,0x27,0x94,0x27,0x94,
0x27,0x94,0xD0,0x8C,0x9B,0x7D,0x3E,0xD7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xCE,0x9B,0x7D,0xEB,0x7C,0xC7,0x74,
0xC7,0x74,0xC7,0x74,0xC7,0x74,0xC7,0x74,0xC7,0x74,0x4A,0xB6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF 

};

   
    TFT.set_font((unsigned char*)font24x23);

   
    // 40wide x 96high pixel flower pot image
    
const unsigned char flowerpot40x96[] = {
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0xFF, 0xFF,
0xF0, 0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 0x1F, 0xFF, 0xFF, 0xE0, 0x00, 0x1F, 0xFF, 0xFF, 0xC0,
0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, 0x08, 0xFF, 0xFF, 0x80, 0x00, 0x08, 0x3F, 0xF8, 0x80, 0x00,
0x10, 0x1F, 0xF0, 0x40, 0x00, 0x20, 0x07, 0xE0, 0x20, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x00,
0x03, 0xC0, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x10, 0x00, 0x01, 0x80, 0x00, 0xFE, 0x00, 0x01,
0x00, 0x01, 0xFF, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x00, 0x00,
0x03, 0xFF, 0xE0, 0x00, 0x00, 0x07, 0xFF, 0xC0, 0x01, 0x00, 0x03, 0xFF, 0xE0, 0x03, 0x00, 0x01,
0xFF, 0xC0, 0x03, 0x80, 0x03, 0xFF, 0xC0, 0x07, 0x80, 0x01, 0xFF, 0xC1, 0x07, 0xC1, 0x00, 0xFF,
0x80, 0xFF, 0xC2, 0x00, 0x7F, 0x00, 0x0F, 0xFC, 0x00, 0x28, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F,
0xF0, 0x00, 0x20, 0x00, 0x1F, 0xF8, 0x00, 0x64, 0x00, 0x1F, 0xFC, 0x00, 0x64, 0x00, 0x3F, 0xFE,
0x00, 0x66, 0x00, 0x7F, 0xFE, 0x00, 0xE6, 0x00, 0xFF, 0xFF, 0x81, 0xE7, 0x03, 0xFF, 0xFF, 0xC3,
0xE7, 0x87, 0xC7, 0xFF, 0xFF, 0xE7, 0xFE, 0x03, 0xFF, 0xFF, 0xE7, 0xF0, 0x03, 0xFF, 0xFF, 0xE7,
0xE0, 0x07, 0xFF, 0xFF, 0xE7, 0xC0, 0x07, 0xFF, 0xFF, 0xE7, 0x80, 0x0F, 0xF8, 0x1F, 0xE7, 0x80,
0x0F, 0xF8, 0x03, 0xE7, 0x80, 0x0F, 0xFC, 0x01, 0xE7, 0x00, 0x1F, 0xFC, 0x00, 0xE7, 0x00, 0x1F,
0xFC, 0x00, 0xE7, 0x00, 0x3F, 0xFE, 0x00, 0xE7, 0x00, 0x3F, 0xFE, 0x00, 0x66, 0x00, 0x7F, 0xFF,
0x00, 0x64, 0x01, 0xFF, 0xFF, 0x00, 0x60, 0x07, 0xFF, 0xFF, 0xC0, 0x67, 0xFF, 0xFF, 0xFF, 0xF0,
0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xC7, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7,
0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF,
0xFF, 0xC0, 0xAA, 0xA2, 0xAA, 0xA0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00,
0xC0, 0x1F, 0xFF, 0xFE, 0x00, 0xE0, 0x1F, 0xFF, 0xFE, 0x01, 0xE0, 0x1F, 0xFF, 0xFE, 0x01, 0xE0,
0x1F, 0xFF, 0xF0, 0x01, 0xF0, 0x1F, 0xFF, 0xFE, 0x03, 0xF0, 0x1F, 0xFF, 0xFE, 0x03, 0xF8, 0x1F,
0xFF, 0xF0, 0x07, 0xF8, 0x1F, 0xFF, 0xFE, 0x07, 0xF8, 0x1F, 0xFF, 0xFE, 0x07, 0xF8, 0x1F, 0xFF,
0xF0, 0x07, 0xFC, 0x1F, 0xFF, 0xFE, 0x0F, 0xFC, 0x1F, 0xFF, 0xFE, 0x0F, 0xFC, 0x1F, 0xFF, 0xF0,
0x0F, 0xFC, 0x1F, 0xFF, 0xFE, 0x0F, 0xFC, 0x1F, 0xFF, 0xFE, 0x0F, 0xFE, 0x1F, 0xFF, 0xF0, 0x1F,
0xFE, 0x1F, 0xFF, 0xFE, 0x1F, 0xFF, 0x1F, 0xFF, 0xFE, 0x3F, 0xFF, 0x1F, 0xFF, 0xF0, 0x3F, 0xFF,
0x1F, 0xFF, 0xFE, 0x3F, 0xFF, 0x1F, 0xFF, 0xFE, 0x3F, 0xFF, 0x9F, 0xFF, 0xF0, 0x7F, 0xFF, 0x9F,
0xFF, 0xFE, 0x7F, 0xFF, 0x9F, 0xFF, 0xFE, 0x7F, 0xFF, 0x9F, 0xFF, 0xF0, 0x7F, 0xFF, 0x9F, 0xFF,
0xFE, 0x7F, 0xFF, 0x9F, 0xFF, 0xFE, 0x7F, 0xFF, 0x9F, 0xFF, 0xFE, 0x7F, 0xFF, 0x80, 0x00, 0x00,
0x7F, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};


  for(int i=0;i<6150;i++)

    {
    
 TFT.lcdWriteData( NXP_banner_bmp[i], NXP_banner_bmp[i+1]);// for bit mapping   
   
      
    }
     wait_ms(500);
  }
}


