#include "mbed.h"
#include "AS3935.h"
 
AS3935 ld(D11, D12, D13, D10, "ld", 2000000); // MOSI, MISO, SCK, CS, SPI bus freq (hz) 
InterruptIn IntLightning(D2); //IRQ AS3935
Serial pc(USBTX, USBRX);
 
void DetectLightning()
{
    char OriginInt;
     wait_ms(2); 
    OriginInt = ld.interruptSource();
    if (OriginInt == 1) { //
        pc.printf(" Noise level too high\r\n");
        }
    if (OriginInt == 4) { //
        pc.printf(" Disturber\r\n");
        }
    if (OriginInt == 8) { // detection
        // pc.printf(" Lightning detection\r\n");
        pc.printf("Lightning detection, distance=%dkm\r\n", ld.lightningDistanceKm());
        pc.printf("Energy %d\r\n", ld.getEnergy());
        ld.clearStats();
 
        }
}
 
 
int main() {
    pc.baud(9600);
    pc.printf("\r\nstart lightning detector\r\n");
    
    //initialisations
//    ld.reset();
    ld.setTuneCap(1); // 500kHz
//    ld.powerUp();
    ld.setIndoors();  
    ld.setMinimumLightnings(1);
    //ld.setSpikeRejection(2);
    ld.setNoiseFloor(2);
  ld.disableDisturbers();
 //   ld.enableDisturbers();
    ld.setWatchdogThreshold(2);
    wait_ms(10);
    IntLightning.rise(&DetectLightning);
    int MinBlysk = ld.getMinimumLightnings();
    int Noise = ld.getNoiseFloor();
    int TuneCap = ld.getTuneCap();
    int SpikeRej = ld.getSpikeRejection();
    int WatchDog = ld.getWatchdogThreshold();
     
    pc.printf(" Min wylad: %i", MinBlysk);
    pc.printf("\r\n");
    pc.printf(" Noise: %i", Noise);
    pc.printf("\r\n");
    pc.printf(" Tune CAP: %i", TuneCap);
    pc.printf("\r\n");
    pc.printf(" Spike rej: %i", SpikeRej);
    pc.printf("\r\n");
    pc.printf(" Watchdog: %i", WatchDog);
    pc.printf("\r\n");
    while(1) {
   //     led1 = ! led1;
        wait(0.2);
     }
    
 
 }