   AREA framefunc, CODE, READONLY
; Export my_asm function location so that C compiler can find it and link
    EXPORT frameout
frameout

; r0 - dsVal array base address
; r1 - data array base address
; r2 - base address for port 0
; r3 - loop counter
; r4 - sclk bitmask
; r5 - RGB channels bitmask
; r6 - data reg 1
; r7 - data reg 2
; r8 - temporary value holding intensity info (used as an offset into dsVal array)


; Save state
    PUSH {R4, R5, R6, R7, R8}

; Load GPIO Port 0 base address in register R6 
    LDR     R2, =0x2009C000 ; GPIO port 0 base address
    
; R3 - loop counter
    MOV     R3, #256
    
; sclk mask
    MOV     R4, #0x00010000 ; sclk bitmask
    
; RGB channels mask
    MOV     R5, #0x03800000 ; bitmask for RGB bits
    
LOOP
    
;NOTE clocking swapped due to inverter used for logic levels|
    ;STR     R4, [R2, #0x18] ; setting clock high
    STR     R4, [R2, #0x1C] ; cleark clk to clock in data (negative edge)

    
    STR     R5, [R2, #0x1C] ; clear RGB via FIOCLEAR
    
    ; R channel
    LDRB     R8, [R1], #1 ; read data word (0-255 intensity) and post-increment array pointer to point to next word in data
    LDRB     R6, [R0, R8] ; loading on/off state from dsVal, pointed to by offset equal to intensity of data
        
  
    ; G channel  
    LDRB     R8, [R1], #1 ; read data word (0-255 intensity) into R8 and post-increment to point to next word in data
    LDRB     R7, [R0, R8] ; loading on/off state from dsVal, pointed to by offset equal to intensity of data
    
    AND     R7, R7, #0x2 ; pick blue channel bit
    
    ORR     R6, R7, R6, lsr #7 ; store RG bits in R6 with clever stuff in R chan
    
    ; B channel
    LDRB     R8, [R1], #1 ; read data word (0-255 intensity) into R8 and post-increment to point to next word in data
    LDRB     R7, [R0, R8] ; loading on/off state from dsVal, pointed to by offset equal to intensity of data    
    
    AND     R7, R7, #0x4 ; pick green channel bit
    
    ; writing to output
    ORR     R6, R6, R7 ; RGB bits in R6
    
    MOV     R6, R6, lsl #23 

    STR     R6, [R2,#0x18] ; FIOSET on/off for LED
    
    SUBS    R3, R3, #0x1 ; decrement loop counter

    STR     R4, [R2, #0x18] ; setting clock high
    
    
    BNE     LOOP
    
    POP {R4, R5, R6, R7, R8}

    BX      LR
    END
