/**
 * @file   MatrixMath.h
 * @author Ernesto Palacios
 *
 * Created on 15 de septiembre de 2011, 09:44 AM.
 *
 *  Develop Under  GPL v3.0 License
 *  http://www.gnu.org/licenses/gpl-3.0.html
 *
 */

#ifndef    MATRIXMATH_H
#define    MATRIXMATH_H

#include "mbed.h"
#include "Matrix.h"


/**
 * @brief This class provides STATIC methods to preform operations over
 * Matrix Objects
 * version 0.8.
 *
 * Methods will be added as neccesary.
 *
 */
class MatrixMath{
public:


    /**@brief
     * Transposes Matrix, return new Object.
     * @param Mat matrix to calculate
     * @return the determinant
     */
    static Matrix Transpose( const Matrix& Mat );


    /**@brief
     * Calculate the inverse of a nxn Matrix BUT check first if the determinant
     * is != 0. Same matrix will be return if Det( Mat ) == 0.
     * @param Mat matrix to calcute inverse.
     * @return Matrix Inverse
     */
    static Matrix Inv( const Matrix& Mat );

    
    static float dotProduct( const Matrix& leftM, const Matrix& rightM );

    /**@brief Calculates the determinant of a Matrix.
     * @param Mat matrix to calculate.
     * @return the determinant.
     */
    static float det( const Matrix& Mat );


    //**  For Kinematics **//

    static Matrix RotX( const Matrix& matrix, float radians );

    static Matrix RotY( const Matrix& matrix, float radians );

    static Matrix RotZ( const Matrix& matrix, float radians );

    static Matrix Transl( const Matrix& matrix, float x, float y, float z );

private:

    /**@brief
     * Calculates the Determinant of a 3x3 Matrix
     * @param Mat Already made sure is a 3 by 3
     * @return Float, determinant.
     */
    float Det3x3( const Matrix& Mat );

};

#endif    /* MATRIXMATH_H */
