/* mbed SRF05 Ultrasonic Rangefiner Library
 * Copyright (c) 2007-2010, cstyles, sford
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


#ifndef MBED_RFSRF05_H
#define MBED_RFSRF05_H

#include "mbed.h"
#include "RF12B.h"

#define CODE0 0x22
#define CODE1 0x44
#define CODE2 0x88

/* SAMPLE IMPLEMENTATION!
RFSRF05 my_srf(p13,p21,p22,p23,p24,p25,p26,p5,p6,p7,p8,p9);


void callbinmain(int num, float dist) {
    //Here is where you deal with your brand new reading ;D
}

int main() {
    pc.printf("Hello World of RobotSonar!\r\n");
    my_srf.callbackfunc = callbinmain;
    
    while (1);
}

 */
class DummyCT;
 
class RFSRF05 {
public:

    RFSRF05(
    PinName trigger, 
    PinName echo0,
    PinName echo1,
    PinName echo2,
    PinName echo3,
    PinName echo4,
    PinName echo5,
    PinName SDI,
    PinName SDO,
    PinName SCK,
    PinName NCS,
    PinName NIRQ);
    
    /** A non-blocking function that will return the last measurement
     *
     * @returns floating point representation of distance in cm
     */
    float read0();
    float read1();
    float read2();
    
    /** A assigns a callback function when a new reading is available **/
    void (*callbackfunc)(int beaconnum, float distance);
    DummyCT* callbackobj;
    void (DummyCT::*mcallbackfunc)(int beaconnum, float distance);
    


    /** A short hand way of using the read function */
    operator float();
    
private :
    RF12B _rf;
    DigitalOut _trigger;
    InterruptIn _echo0;
    InterruptIn _echo1;
    InterruptIn _echo2;
    InterruptIn _echo3;
    InterruptIn _echo4;
    InterruptIn _echo5;
    Timer _timer;
    Ticker _ticker;
    void _rising (void);
    void _falling (void);
    void _startRange (void);
    float _dist[3];
    char _code[3];
    int _beacon_counter;
    bool ValidPulse;
    
};

#endif
