#ifndef EUROBOT_ACTUATORS_ARMS_ARM_H_
#define EUROBOT_ACTUATORS_ARMS_ARM_H_

#include "mbed.h"

namespace arm
{

class Arm;

extern Arm lower_arm;
extern Arm upper_arm;


class Arm 
{
public:
    Arm (PwmOut pwm_in, float period_in, float min_pos_in, float max_pos_in)
       : pwm_(pwm_in), period_(period_in), min_pos_(min_pos_in), max_pos_(max_pos_in)
    {
        pwm_.period(period_);
    }

    void go_up()
    {
        pwm_.pulsewidth_us(max_pos_*1000);
    }
    
    void go_down()
    {
        pwm_.pulsewidth_us(min_pos_*1000);
    }

private:
    PwmOut pwm_;
    float period_;
    float min_pos_;
    float max_pos_;

};

} //namespace

#endif