#include "globals.h"
#include "Kalman.h"
#include "mbed.h"
#include "rtos.h"
#include "Arm.h"
#include "MainMotor.h"
#include "Encoder.h"
#include "Colour.h"
#include "CakeSensor.h"
#include "Printing.h"
#include "coprocserial.h"
#include <algorithm>
#include "motion.h"
#include "MotorControl.h"
#include "system.h"
#include "ai.h"

void motortest();
void encodertest();
void motorencodetest();
void motorencodetestline();
void motorsandservostest();
void armtest();
void motortestline();
void colourtest();
void cakesensortest();
void printingtestthread(void const*);
void printingtestthread2(void const*);
void feedbacktest();

DigitalOut *balloon_ptr;

void timeisup_isr(){
    MotorControl::motorsenabled = 0;
    *balloon_ptr = 0;
}

int main()
{

    /*****************
     *   Test Code   *
     *****************/
    //motortest();
    //encodertest();
    //motorencodetest();
    //motorencodetestline();
    //motorsandservostest();
    //armtest();
    //while(1);
    //motortestline();
    //ledtest();
    //phototransistortest();
    //ledphototransistortest();
    //colourtest(); // Red SnR too low
    //cakesensortest();
    //feedbacktest();

    /*
    DigitalOut l1(LED1);
    Thread p(Printing::printingloop,        NULL,   osPriorityNormal,   2048);
    l1=1;
    Thread a(printingtestthread,    NULL,   osPriorityNormal,   1024);
    Thread b(printingtestthread2,   NULL,   osPriorityNormal,   1024);
    Thread::wait(osWaitForever);
    */
    
    SystemTime.start();
    
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    InitSerial();
    wait(3);
    Kalman::KalmanInit();
    
    Thread predictthread(Kalman::predictloop, NULL, osPriorityNormal, 2084);//512); //temp 2k
    Kalman::start_predict_ticker(&predictthread);
    
    Thread updatethread(Kalman::updateloop, NULL, osPriorityNormal, 2084);
    
    Ticker motorcontroltestticker;
    motorcontroltestticker.attach(MotorControl::motor_control_isr, 0.05);
    // ai layer thread
    Thread aithread(AI::ailayer, NULL, osPriorityNormal, 2048);
    
    // motion layer periodic callback
    RtosTimer motion_timer(motion::motionlayer, osTimerPeriodic);
    motion_timer.start(50);

    Thread printingThread(Printing::printingloop, NULL, osPriorityLow, 2048);
    
    //worry about starting
    DigitalIn startcord(P_START_CORD);
    startcord.mode(PullUp);
    while(!startcord)
        Thread::wait(50);
        
    //worry about stopping
    DigitalOut balloon(P_BALLOON);
    balloon = 1;
    balloon_ptr = &balloon;
    Timeout timeout_90s;
    timeout_90s.attach(timeisup_isr, 90);
    
    aithread.signal_set(0x2); //Tell AI thread that its time to go
    
    
    measureCPUidle(); //repurpose thread for idle measurement
    /*
    MotorControl::set_omegacmd(0);
    for(float spd = 0.02; spd <= 0.5; spd *= 1.4){
    
        MotorControl::set_fwdcmd(spd);
        
        Thread::wait(3000);
        
        float f = MotorControl::mfwdpowdbg;
        float r = MotorControl::mrotpowdbg;
        MotorControl::set_fwdcmd(0);
        printf("targetspd:%f, fwd:%f, rot:%f\r\n", spd, f, r);
        Thread::wait(5000);
    }
    
    MotorControl::set_fwdcmd(0);
    for(float spd = 0.05; spd <= 2; spd *= 1.4){
    
        MotorControl::set_omegacmd(spd);
        
        Thread::wait(3000);
        
        float f = MotorControl::mfwdpowdbg;
        float r = MotorControl::mrotpowdbg;
        MotorControl::set_omegacmd(0);
        printf("targetspd:%f, fwd:%f, rot:%f\r\n", spd, f, r);
        Thread::wait(5000);
    }
    */
    Thread::wait(osWaitForever);
   
}

#include <cstdlib>
using namespace std;

void printingtestthread(void const*)
{
    const char ID = 1;
    float buffer[3] = {ID};
    Printing::registerID(ID,sizeof(buffer)/sizeof(buffer[0]));
    while (true){
        for(size_t i = 1; i != sizeof(buffer)/sizeof(buffer[0]); ++i){
            buffer[i] = ID ;
        }
        Printing::updateval(ID, buffer, sizeof(buffer)/sizeof(buffer[0]));
        Thread::wait(200);
    }
}

void printingtestthread2(void const*)
{
    const char ID = 2;
    float buffer[5] = {ID};
    Printing::registerID(ID,sizeof(buffer)/sizeof(buffer[0]));
    while (true){
        for(size_t i = 1; i != sizeof(buffer)/sizeof(buffer[0]); ++i){
            buffer[i] = ID;
        }
        Printing::updateval(ID, buffer, sizeof(buffer)/sizeof(buffer[0]));
        Thread::wait(500);
    }
}


/*
void feedbacktest(){
    //Encoder Eright(P_ENC_RIGHT_A, P_ENC_RIGHT_B), Eleft(P_ENC_LEFT_A, P_ENC_LEFT_B);
    MainMotor mright(P_MOT_RIGHT_A, P_MOT_RIGHT_B), mleft(P_MOT_LEFT_A, P_MOT_LEFT_B);

    Kalman::State state;

    float Pgain = -0.01;
    float fwdspeed = -400/3.0f;
    Timer timer;
    timer.start();

    while(true) {
        float expecdist = fwdspeed * timer.read();
        state = Kalman::getState();
        float errleft = left_encoder.getTicks() - (expecdist);
        float errright = right_encoder.getTicks() - expecdist;

        mleft(max(min(errleft*Pgain, 0.4f), -0.4f));
        mright(max(min(errright*Pgain, 0.4f), -0.4f));
    }
}
*/

void cakesensortest()
{
    wait(1);
    printf("cakesensortest");

    CakeSensor cs(P_DISTANCE_SENSOR);
    while(true) {
        wait(0.1);
        printf("distance: %f\t %f\r\n", cs.Distance(),cs.Distanceincm());
    }
}

void colourtest()
{
    Colour c_upper(P_COLOR_SENSOR_BLUE_UPPER, P_COLOR_SENSOR_RED_UPPER, P_COLOR_SENSOR_IN_UPPER,UPPER);
    Colour c_lower(P_COLOR_SENSOR_BLUE_LOWER, P_COLOR_SENSOR_RED_LOWER, P_COLOR_SENSOR_IN_LOWER,LOWER);

    while(true) {
        wait(0.1);

        switch(c_lower.getColour()) {
            case BLUE :
                printf("BLUE\n");
                break;
            case RED:
                printf("RED\n");
                break;
            case WHITE:
                printf("WHITE\n");
                break;
            case BLACK:
                printf("BLACK\n");
                break;
            default:
                printf("BUG\n");
        }

    }

}

/*

void pt_test()
{
    DigitalOut _blue_led(p10);
    DigitalOut _red_led(p11);
    AnalogIn _pt(p18);
    
    bytepack_t datapackage;
    // first 3 bytes of header is used for alignment
    datapackage.data.header[0] = 0xFF;
    datapackage.data.header[1] = 0xFF;
    datapackage.data.header[2] = 0xFF;
    while(true) {
        //toggles leds for the next state
        _blue_led = 1;
        _red_led = 0;
        wait(0.01);
        volatile float blue_temp = _pt.read();


        datapackage.data.ID = (unsigned char)0;
        datapackage.data.value = blue_temp;
        datapackage.data.aux = 0;
        for (int i = 0; i < sizeof(datapackage); i++) {
            //mbed_serial.putc(datapackage.type_char[i]);
            pc.putc(datapackage.type_char[i]);
        }

        _blue_led = 0;
        _red_led = 1;
        wait(0.01);
        volatile float red_temp = _pt.read();


        datapackage.data.ID = (unsigned char)1;
        datapackage.data.value = red_temp;
        datapackage.data.aux = 0;
        for (int i = 0; i < sizeof(datapackage); i++) {
            //mbed_serial.putc(datapackage.type_char[i]);
            pc.putc(datapackage.type_char[i]);
        }

        _blue_led = 0;
        _red_led = 0;
        wait(0.01);
        volatile float noise_temp = _pt.read();


        datapackage.data.ID = (unsigned char)2;
        datapackage.data.value = noise_temp;
        datapackage.data.aux = 0;
        for (int i = 0; i < sizeof(datapackage); i++) {
            //mbed_serial.putc(datapackage.type_char[i]);
            pc.putc(datapackage.type_char[i]);
        }

    }
}
*/
#ifdef AGDHGADSYIGYJDGA
PwmOut white(p26);
PwmOut black(p25);

void armtest() 
{    
    
    white.period(0.05);
    black.period(0.05);
    
  /*  float f=1;
    for (f=1; f<3; f+=0.1)
    { 
        black.pulsewidth_us(f*1000);
        wait(1);
        printf("%f\r\n", f);
    }
    for (f=2; f>0; f-=0.1)
    { 
        black.pulsewidth_us(f*1000);
        wait(1);
        printf("%f\r\n", f);
    }*/
    
    
    for(;;)
    {
        black.pulsewidth_us(2.0*1000);
        wait(2);
        black.pulsewidth_us(0.9*1000);//1.2
        wait(2);
    }
    
    // white works
    /*for(;;)
    {
        white.pulsewidth_us(0.6*1000);
        wait(2);
        white.pulsewidth_us(2.5*1000);
        wait(2);
    }*/
    
   /* while(1) //2.5 -> //0.6
    {
        white.pulsewidth_us(int(f*1000));
        printf("%f\r\n", f);
        f-=0.1;
        wait(1);
    }*/
}
#endif
#ifdef FSDHGFSJDF
void armtest()
{
    Arm lower_arm(p25, 0.05, 0.9, 2.0);
    Arm upper_arm(p26, 0.05, 0.6, 2.5);
    
    while(1)
    {
        upper_arm.go_up();
        wait(2);
        upper_arm.go_down();
        wait(2);
    }
}
#endif
void armtest(){}
/*
void motorsandservostest()
{
    Encoder Eleft(p27, p28), Eright(p30, p29);
    MainMotor mleft(p24,p23), mright(p21,p22);
    Arm sTop(p25), sBottom(p26);
    //Serial pc(USBTX, USBRX);
    const float speed = 0.0;
    const float dspeed = 0.0;

    Timer servoTimer;
    mleft(speed);
    mright(speed);
    servoTimer.start();
    while (true) {
        printf("Position is: %i \t %i \n\r", Eleft.getTicks(), Eright.getTicks());
        if (Eleft.getTicks() < Eright.getTicks()) {
            mleft(speed);
            mright(speed - dspeed);
        } else {
            mright(speed);
            mleft(speed - dspeed);
        }
        if (servoTimer.read() < 1) {
            sTop.clockwise();
        } else if (servoTimer.read() < 4) {
            sTop.halt();
        } else if (servoTimer.read() < 5) {
            sBottom.anticlockwise();
            //Led=1;
        } else if (servoTimer.read() < 6) {
            sBottom.clockwise();
            //Led=0;
        } else if (servoTimer.read() < 7) {
            sBottom.halt();
        } else {
            sTop.anticlockwise();
        }
        if (servoTimer.read() >= 9) servoTimer.reset();
    }
}
*/
void motortestline()
{
    MainMotor mleft(p24,p23), mright(p21,p22);
    const float speed = 0.2;
    mleft(speed);
    mright(speed);
    while(true) wait(1);
}

void motorencodetestline()
{
    Encoder Eright(P_ENC_RIGHT_A, P_ENC_RIGHT_B), Eleft(P_ENC_LEFT_A, P_ENC_LEFT_B);
    MainMotor mright(P_MOT_RIGHT_A, P_MOT_RIGHT_B), mleft(P_MOT_LEFT_A, P_MOT_LEFT_B);
    //Serial pc(USBTX, USBRX);
    const float speed = 0.2;
    const float dspeed = 0.1;

    mleft(speed);
    mright(speed);
    while (true) {
        //left 27 cm = 113 -> 0.239 cm/pulse
        //right 27 cm = 72 -> 0.375 cm/pulse
        printf("Position is: %i \t %i \n\r", (int)(Eleft.getTicks()*0.239), (int)(Eright.getTicks()*0.375));
        if (Eleft.getTicks()*0.239 < Eright.getTicks()*0.375) {
            mright(speed - dspeed);
        } else {
            mright(speed + dspeed);
        }
    }

}

void motorencodetest()
{
    Encoder Eright(P_ENC_RIGHT_A, P_ENC_RIGHT_B), Eleft(P_ENC_LEFT_A, P_ENC_LEFT_B);
    MainMotor mright(P_MOT_RIGHT_A, P_MOT_RIGHT_B), mleft(P_MOT_LEFT_A, P_MOT_LEFT_B);
    Serial pc(USBTX, USBRX);

    const float speed = -0.3;
    const int enc = -38;
    while(true) {
        mleft(speed);
        mright(0);
        while(Eleft.getTicks()>enc) {
            printf("Position is: %i \t %i \n\r", Eleft.getTicks(), Eright.getTicks());
        }
        Eleft.reset();
        Eright.reset();
        mleft(0);
        mright(speed);
        while(Eright.getTicks()>enc) {
            printf("Position is: %i \t %i \n\r", Eleft.getTicks(), Eright.getTicks());
        }
        Eleft.reset();
        Eright.reset();
    }
}

void encodertest()
{
    Encoder E1(P_ENC_LEFT_A, P_ENC_LEFT_B);
    //Encoder E2(P_ENC_RIGHT_A, P_ENC_RIGHT_B);
    Serial pc(USBTX, USBRX);
    while(true) {
        wait(0.1);
        printf("Position is: %i \t %i \n\r", E1.getTicks(), 0);//E2.getTicks());
    }

}
void motortest()
{
    MainMotor mright(p22,p21), mleft(p23,p24);
    while(true) {
        wait(1);
        mleft(0.8);
        mright(0.8);
        wait(1);
        mleft(-0.2);
        mright(0.2);
        wait(1);
        mleft(0);
        mright(0);
    }
}