
// Eurobot13 Colour.h
#ifndef COLOUR_H
#define COLOUR_H

#include "mbed.h"
#include "globals.h"
#include "math.h"

#define BUFF_SIZE 10
#define SNR_THRESHOLD_DB 4

#define UPPERARM_CORRECTION 2.310f
#define LOWERARM_CORRECTION 1.000f


enum ColourEnum {BLUE=0, RED, WHITE, BLACK};
enum ArmEnum {UPPER=0, LOWER};

class Colour{
public:

    Colour(
    PinName blue_led, 
    PinName red_led,
    PinName pt,
    ArmEnum arm);
    
    ColourEnum getColour();


private:
    Ticker ticker;
    DigitalOut blue_led;
    DigitalOut red_led;
    AnalogIn pt;
    ArmEnum arm;
    
    float red_correction_factor;
    float colour;
    float SNR;
    void Blink();
    
    int togglecolour;
    float blue;
    float blue_buff[BUFF_SIZE];
    float red;
    float red_buff[BUFF_SIZE];
    float noise;
    float noise_buff[BUFF_SIZE];
    
    int buff_pointer;    
    
};

#endif