#include "Kalman.h"
#include "mbed.h"
#include "globals.h"

Serial coprocserial(NC, P_SERIAL_RX);

//DigitalOut OLED1(LED1);
//DigitalOut OLED3(LED3);

// bytes packing
typedef union {

    struct _data{
        unsigned char sync[3];
        unsigned char ID;
        float value;
        float variance;
    } data;
    
    unsigned char type_char[12];
} bytepack_t;

bytepack_t incbuff;

volatile int buffprintflag = 0;
void printbuff(){
    while(!buffprintflag);
    buffprintflag = 0;
    for(int i = 0; i < 9; i++){
        printf("%x ", incbuff.type_char[i]);
    }
    printf("\r\n");
}

void procserial(){

    //Fetch the byte in a "clear interrupt" sense
    unsigned char c = LPC_UART1->RBR;
    
    //OLED1 = !OLED1;
    
    static int ctr = 0;
    

    if (ctr < 3){
        if (c == 0xFF)
            ctr++;
        else
            ctr = 0;
    } else {
        incbuff.type_char[ctr] = c;
        if (++ctr == 12){
            ctr = 0;
            
            //OLED3 = !OLED3;
            buffprintflag = 1;
            
            //runupdate
            Kalman::runupdate((Kalman::measurement_t)incbuff.data.ID, incbuff.data.value, incbuff.data.variance);
        }
    }
    
}

void InitSerial(){
    
    coprocserial.baud(115200);

    printf("attachserial\r\n");
    coprocserial.attach(procserial);
}