#include "mbed.h"  // this tells us to load mbed related functions

DigitalOut red(LED_RED);             // we create a variable 'red', use it as an out port
Ticker flipper;   //Ticker = recurring interrupt to repeatedly call a function at a specified rate

// YOUR CODE HERE

//REMOVE
static void blinky() {
    // the LED is either on or off (a 1 or a 0). We can inverse the value with the `!` (inverse operator).
    // the flipped value is what we write back to the LED, thus toggling the LED.
    red = !red;
}
//END_REMOVE

// this code runs when the microcontroller starts up 
int main() {
    red = 1;  //turn the led off, (1=off, I know it's weird)
    
    // we want to blink an led, every 500 ms.
    flipper.attach(&blinky, 0.5); // the address of the function to be attached (flip) and the interval (in seconds)
 
    // spin in a main loop. flipper will interrupt it to call flip
    while(1) {}
}
